/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import io.github.noeppi_noeppi.libx.base.tile.BlockBE;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.BlockFunctionalFlower;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import mythicbotany.functionalflora.base.RenderFunctionalFlower;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import vazkii.botania.xplat.BotaniaConfig;

public class BlockFloatingFunctionalFlower<T extends FunctionalFlowerBase>
extends BlockBE<T> {
    private static final VoxelShape SHAPE = BlockFloatingFunctionalFlower.m_49796_((double)1.6, (double)1.6, (double)1.6, (double)14.4, (double)14.4, (double)14.4);
    private final BlockFunctionalFlower<T> nonFloatingBlock;

    public BlockFloatingFunctionalFlower(ModX mod, Class<T> beClass, BlockFunctionalFlower<T> nonFloatingBlock) {
        super(mod, beClass, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60924_((state, world, pos) -> false).m_60966_().m_60918_(SoundType.f_56740_));
        this.nonFloatingBlock = nonFloatingBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        BlockEntityRenderers.m_173590_((BlockEntityType)this.getBlockEntityType(), mgr -> new RenderFunctionalFlower());
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110457_());
    }

    public BlockFunctionalFlower<T> getNonFloatingBlock() {
        return this.nonFloatingBlock;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos pos) {
        FunctionalFlowerBase te = (FunctionalFlowerBase)this.getBlockEntity(level, pos);
        if (te.getCurrentMana() > 0) {
            return 1 + (int)((double)te.getCurrentMana() / (double)te.maxMana * 14.0);
        }
        return 0;
    }

    public boolean m_7420_(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (this.getNonFloatingBlock().isGenerating) {
            tooltip.add((Component)new TranslatableComponent("botania.flowerType.generating").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)new TranslatableComponent("botania.flowerType.functional").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        tooltip.add((Component)new TranslatableComponent("block." + this.mod.modid + "." + this.getNonFloatingBlock().getRegistryName().m_135815_() + ".description").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return BotaniaConfig.client().staticFloaters() ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

