/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.patchouli.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.glyphs.MissingGlyph;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PageJson {
    public static JsonElement stack(ItemStack stack) {
        StringBuilder sb = new StringBuilder();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.m_41720_());
        if (id == null) {
            throw new IllegalStateException("Item not registered: " + stack);
        }
        sb.append(id.m_135827_());
        sb.append(":");
        sb.append(id.m_135815_());
        if (stack.m_41613_() != 1) {
            sb.append("#");
            sb.append(stack.m_41613_());
        }
        if (stack.m_41782_() && !stack.m_41784_().m_128456_()) {
            sb.append(stack.m_41784_());
        }
        return new JsonPrimitive(sb.toString());
    }

    public static List<String> splitText(String text) {
        return PageJson.splitText(text, false);
    }

    public static List<String> splitText(String text, boolean withInit) {
        return PageJson.splitText(text, withInit ? 14 : 16, 16);
    }

    public static List<String> splitText(String text, int skip) {
        return PageJson.splitText(text, Math.max(16 - skip, 1), 16);
    }

    public static List<String> splitText(String text, int linesHead, int linesTail) {
        StringSplitter splitter = new StringSplitter((codePoint, style) -> MissingGlyph.INSTANCE.m_83827_(style.m_131154_()));
        TextComponent component = new TextComponent(text);
        List<String> lines = splitter.m_92432_(text, Math.round(174.0f), Style.f_131099_).stream().map(FormattedText::getString).map(String::strip).filter(s -> !s.isEmpty()).toList();
        ArrayList<String> pages = new ArrayList<String>();
        boolean first = true;
        while (!lines.isEmpty()) {
            pages.add(lines.stream().limit(first ? (long)linesHead : (long)linesTail).collect(Collectors.joining(" ")));
            lines = lines.stream().skip(first ? (long)linesHead : (long)linesTail).toList();
            first = false;
        }
        return List.copyOf(pages);
    }
}

