/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.patchouli.content;

import com.google.gson.JsonObject;
import java.util.List;
import mythicbotany.data.patchouli.content.Content;
import mythicbotany.data.patchouli.page.PageBuilder;
import mythicbotany.data.patchouli.page.PageJson;

public record TextContent(String text, boolean caption) implements Content
{
    @Override
    public void pages(PageBuilder builder) {
        List<String> pages = PageJson.splitText(this.text(), builder.isFirst());
        TextContent.addTextPages(builder, pages, true);
    }

    @Override
    public Content with(Content next) {
        if (next instanceof TextContent) {
            TextContent tc = (TextContent)next;
            if (!this.caption() || tc.caption()) {
                return new TextContent(this.text() + " " + tc.text(), this.caption());
            }
        }
        return Content.super.with(next);
    }

    public static void addTextPages(PageBuilder builder, List<String> pages, boolean includeFirst) {
        for (String page : includeFirst ? pages : pages.stream().skip(1L).toList()) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "patchouli:text");
            json.addProperty("text", builder.translate(page));
            builder.addPage(json);
        }
    }
}

