/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.patchouli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mythicbotany.data.patchouli.CategoryBuilder;
import mythicbotany.data.patchouli.EntryBuilder;
import mythicbotany.data.patchouli.translate.TranslationManager;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class PatchouliProviderBase
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final ModX mod;
    protected final DataGenerator generator;
    protected final ExistingFileHelper fileHelper;
    private final String bookName;
    private final List<CategoryBuilder> categories;
    private final Set<ResourceLocation> categoryIds;
    private final List<EntryBuilder> entries;

    public PatchouliProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper, String bookName) {
        this.mod = mod;
        this.generator = generator;
        this.fileHelper = fileHelper;
        this.bookName = bookName;
        this.categories = new ArrayList<CategoryBuilder>();
        this.categoryIds = new HashSet<ResourceLocation>();
        this.entries = new ArrayList<EntryBuilder>();
    }

    protected abstract void setup();

    public CategoryBuilder category(String id) {
        CategoryBuilder builder = new CategoryBuilder(this.mod.resource(id));
        this.categories.add(builder);
        this.categoryIds.add(builder.id);
        return builder;
    }

    public EntryBuilder entry(String id) {
        if (this.categories.isEmpty()) {
            throw new IllegalStateException("No categories defined");
        }
        return this.entry(id, this.categories.get((int)(this.categories.size() - 1)).id);
    }

    public EntryBuilder entry(String id, String category) {
        return this.entry(id, this.mod.resource(category));
    }

    public EntryBuilder entry(String id, ResourceLocation category) {
        if (this.mod.modid.equals(category.m_135827_()) && !this.categoryIds.contains(category)) {
            throw new IllegalArgumentException("Unknown category: " + category);
        }
        EntryBuilder builder = new EntryBuilder(id, category);
        this.entries.add(builder);
        return builder;
    }

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + " patchouli book";
    }

    public void m_6865_(@Nonnull HashCache cache) throws IOException {
        Path path;
        this.setup();
        TranslationManager mgr = new TranslationManager(this.bookName);
        for (int i = 0; i < this.categories.size(); ++i) {
            CategoryBuilder category = this.categories.get(i);
            path = this.generator.m_123916_().resolve("assets/" + category.id.m_135827_() + "/patchouli_books/" + this.bookName + "/en_us/categories/" + category.id.m_135815_() + ".json");
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)category.build(mgr, i), (Path)path);
        }
        for (EntryBuilder entry : this.entries) {
            path = this.generator.m_123916_().resolve("assets/" + entry.category.m_135827_() + "/patchouli_books/" + this.bookName + "/en_us/entries/" + entry.category.m_135815_() + "/" + entry.id + ".json");
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)entry.build(mgr, this.fileHelper), (Path)path);
        }
        Path langPath = this.generator.m_123916_().resolve("assets/" + this.mod.modid + "_" + this.bookName + "/lang/en_us.json");
        DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)mgr.build(), (Path)langPath);
    }
}

