/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.config;

import io.github.noeppi_noeppi.libx.config.Config;
import io.github.noeppi_noeppi.libx.config.Group;
import io.github.noeppi_noeppi.libx.config.validator.DoubleRange;
import io.github.noeppi_noeppi.libx.config.validator.FloatRange;
import io.github.noeppi_noeppi.libx.config.validator.IntRange;
import mythicbotany.config.ArmorStats;
import mythicbotany.config.ToolDamageStats;
import mythicbotany.mjoellnir.MjoellnirHoldRequirement;

public class MythicConfig {
    @Config(value={"Whether the alfheim dimension is enabled. When this is set to false, you'll still be able to use", "the mead of kvasir as usual but the portal to alfheim will not work."})
    public static boolean enableAlfheim = true;
    @Config(value={"Whether players that manage to get to alfheim via another mod but have not drunk the mead of kvasir", "should get a blindness effect."})
    public static boolean lockAlfheim = true;
    @Config(value={"Whether to replace the recipe for the Gaia Pylon with a recipe that requires Alfsteel."})
    public static boolean replaceGaiaRecipe = true;

    public static class spawns {

        @Group(value={"Spawn configuration for the illusioner in alfheim."})
        public static class illusioner {
            @Config
            public static int weight = 1;
            @Config
            public static int min = 1;
            @Config
            public static int max = 1;
        }

        @Group(value={"Spawn configuration for the witches in alfheim."})
        public static class witch {
            @Config
            public static int weight = 2;
            @Config
            public static int min = 1;
            @Config
            public static int max = 2;
        }

        @Group(value={"Spawn configuration for the alf pixie."})
        public static class pixies {
            @Config
            public static int weight = 5;
            @Config
            public static int min = 4;
            @Config
            public static int max = 10;
        }
    }

    public static class mjoellnir {
        @Config(value={"What is required for a player to hold mjoellnir.", "nothing  - Players will always be able to hold mjoellnir.", "effect   - Players need the absorption effect to hold mjoellnir.", "hearts   - Players need absorption hearts to hold mjoellnir.", "           If they run out of golden hearts but still have the effect, mjoellnir is dropped."})
        public static MjoellnirHoldRequirement requirement = MjoellnirHoldRequirement.EFFECT;
        @Config(value={"What is required for a player that holds the ring of thor to hold mjoellnir.", "If a player holds the ring of thor, this OR `mjoellnir.requirement` must be met."})
        public static MjoellnirHoldRequirement requirement_thor = MjoellnirHoldRequirement.NOTHING;
        @Config(value={"The base damage for melee attacks."})
        @FloatRange(min=1.0f)
        public static float base_damage_melee = 25.0f;
        @Config(value={"The base damage for the main target on ranged attacks."})
        @FloatRange(min=1.0f)
        public static float base_damage_ranged = 25.0f;
        @Config(value={"Enchantment multiplier for sharpness and power enchantments."})
        @FloatRange(min=1.0f)
        public static float enchantment_multiplier = 5.0f;
        @Config(value={"The damage dealt to secondary targets on ranged attacks.", "This value is multiplied with the damage to the main target."})
        @FloatRange(min=0.0f, max=1.0f)
        public static float secondary_target_multiplier = 0.4f;
        @Config(value={"The chance for secondary targets to get lightning effects  applied as well on ranged attacks."})
        @FloatRange(min=0.0f, max=1.0f)
        public static float secondary_lightning_chance = 0.25f;
        @Config(value={"The base attack speed attribute for mjoellnir."})
        public static float base_attack_speed = -3.5f;
        @Config(value={"The amount the attack speed increases per level of hammer mobility."})
        @FloatRange(min=0.0f)
        public static float attack_speed_multiplier = 0.2f;
        @Config(value={"The cooldown in ticks after a ranged attack, before mjoellnir can be thrown again."})
        @IntRange(min=0)
        public static int ranged_cooldown = 120;
    }

    public static class alftools {
        @Config(value={"Reach distance modifier for the alfsteel helmet"})
        @DoubleRange(min=0.0)
        public static double reach_modifier = 2.0;
        @Config(value={"Knockback resistance modifier for the alfsteel chestplate"})
        @DoubleRange(min=0.0)
        public static double knockback_resistance_modifier = 1.0;
        @Config(value={"Speed modifier for the alfsteel leggings"})
        @DoubleRange(min=0.0)
        public static double speed_modifier = 0.05;
        @Config(value={"Jump boost modifier for the alfsteel boots"})
        @FloatRange(min=0.0f)
        public static float jump_modifier = 0.025f;

        @Group(value={"Armor stats for alfsteel armor."})
        public static class armor_values {
            @Config
            public static ArmorStats helmet = new ArmorStats(3, 3.0f);
            @Config
            public static ArmorStats chestplate = new ArmorStats(8, 3.0f);
            @Config
            public static ArmorStats leggings = new ArmorStats(6, 3.0f);
            @Config
            public static ArmorStats boots = new ArmorStats(3, 3.0f);
        }

        public static class tool_values {
            @Config(value={"The attack damage dealt by the alf blade"})
            public static double sword_damage = 12.0;
            @Config(value={"The attack speed modifier for the alf blade"})
            public static double sword_speed = 2.4;
        }

        @Group(value={"Durability stats for alfsteel tools.", "  max_durability      is the maximum durability, a tool has", "  mana_per_durability is the amount of mana consumed per durability loss"})
        public static class durability {
            @Config
            public static ToolDamageStats sword = new ToolDamageStats(4600, 200);
            @Config
            public static ToolDamageStats axe = new ToolDamageStats(4600, 200);
            @Config
            public static ToolDamageStats pickaxe = new ToolDamageStats(4600, 200);
            @Config
            public static ToolDamageStats armor = new ToolDamageStats(5200, 100);
        }
    }

    public static class flowers {
        @Config(value={"How much mana a wither aconite should generate per nether star."})
        @IntRange(min=1)
        public static int witherAconiteMana = 1200000;

        @Group(value={"Can be used to tweak the multipliers for the raindeletia. All matching values are multiplied", "The result is the mana generated per tick."})
        public static class raindeletia {
            @Config(value={"Base modifier. This one will always be applied"})
            @FloatRange(min=0.0f)
            public static float base = 5.0f;
            @Config(value={"Modifier for normal rain, not for thunder"})
            @FloatRange(min=0.0f)
            public static float rain = 0.09f;
            @Config(value={"Modifier for thundering"})
            @FloatRange(min=0.0f)
            public static float thunder = 3.0f;
            @Config(value={"Modifier for dry grass"})
            @FloatRange(min=0.0f)
            public static float dry_grass = 0.5f;
            @Config(value={"Modifier for vivid grass"})
            @FloatRange(min=0.0f)
            public static float vivid_grass = 2.0f;
            @Config(value={"Modifier for enchanted soil"})
            @FloatRange(min=0.0f)
            public static float enchanted_soil = 5.0f;
        }
    }
}

