/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.base;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;

@OnlyIn(value=Dist.CLIENT, _interface=IWandHUD.class)
public abstract class BlockEntityMana
extends BlockEntityBase
implements ISparkAttachable,
IManaReceiver,
IWandHUD,
IWandable {
    public final int maxMana;
    private final boolean bursts;
    private final boolean sparks;
    protected int mana;

    public BlockEntityMana(BlockEntityType<?> type, BlockPos pos, BlockState state, int maxMana, boolean bursts, boolean sparks) {
        super(type, pos, state);
        this.maxMana = maxMana;
        this.bursts = bursts;
        this.sparks = sparks;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeCapabilities.MANA_RECEIVER || cap == BotaniaForgeCapabilities.WANDABLE || cap == BotaniaForgeCapabilities.SPARK_ATTACHABLE && this.sparks) {
            return LazyOptional.of(() -> this).cast();
        }
        return (LazyOptional)DistExecutor.unsafeRunForDist(() -> () -> cap == BotaniaForgeClientCapabilities.WAND_HUD ? LazyOptional.of(() -> this).cast() : super.getCapability(cap, side), () -> () -> super.getCapability(cap, side));
    }

    protected abstract boolean canReceive();

    public boolean canAttachSpark(ItemStack itemStack) {
        return this.sparks;
    }

    public int getAvailableSpaceForMana() {
        return Mth.m_14045_((int)(this.maxMana - this.mana), (int)0, (int)this.maxMana);
    }

    public IManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_142082_(1, 1, 1)), (Predicate)Predicates.instanceOf(IManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (IManaSpark)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.mana < this.maxMana && this.canReceive();
    }

    public boolean isFull() {
        return this.mana >= this.maxMana;
    }

    public void receiveMana(int i) {
        this.mana = Mth.m_14045_((int)(this.mana + i), (int)0, (int)this.maxMana);
        this.onManaChange();
        this.m_6596_();
    }

    public boolean canReceiveManaFromBursts() {
        return this.bursts;
    }

    public int getCurrentMana() {
        return Mth.m_14045_((int)this.mana, (int)0, (int)this.maxMana);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.mana = nbt.m_128425_("mana", 3) ? Mth.m_14045_((int)nbt.m_128451_("mana"), (int)0, (int)this.maxMana) : 0;
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("mana", Mth.m_14045_((int)this.mana, (int)0, (int)this.maxMana));
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (!this.f_58857_.f_46443_) {
            tag.m_128405_("mana", this.mana);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (this.f_58857_.f_46443_) {
            this.mana = Mth.m_14045_((int)tag.m_128451_("mana"), (int)0, (int)this.maxMana);
        }
    }

    public void renderHUD(PoseStack poseStack, Minecraft minecraft) {
        String name = I18n.m_118938_((String)this.f_58856_.m_60734_().m_7705_(), (Object[])new Object[0]);
        BotaniaAPIClient.instance().drawSimpleManaHUD(poseStack, this.getManaColor(), this.getCurrentMana(), this.maxMana, name);
    }

    public boolean onUsedByWand(@Nullable Player player, ItemStack itemStack, Direction direction) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            LibX.getNetwork().requestBE(this.f_58857_, this.f_58858_);
        }
        return true;
    }

    protected void onManaChange() {
    }

    protected int getManaColor() {
        return 255;
    }

    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }
}

