/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import mythicbotany.ModItems;
import mythicbotany.MythicBotany;
import mythicbotany.config.MythicConfig;
import mythicbotany.network.AlfSwordLeftClickSerializer;
import mythicbotany.pylon.PylonRepairable;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.lib.ModTags;

public class AlfsteelSword
extends ItemTerraSword
implements PylonRepairable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public AlfsteelSword(Item.Properties props) {
        super(props.m_41503_(MythicConfig.alftools.durability.sword.max_durability()));
        MinecraftForge.EVENT_BUS.addListener(this::onLeftClick);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MythicConfig.alftools.tool_values.sword_speed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    private void onLeftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().m_41619_() && evt.getItemStack().m_41720_() == this) {
            MythicBotany.getNetwork().channel.sendToServer((Object)new AlfSwordLeftClickSerializer.AlfSwordLeftClickMessage());
        }
    }

    public int getManaPerDamage() {
        return 2 * super.getManaPerDamage();
    }

    public float m_43299_() {
        return (float)MythicConfig.alftools.tool_values.sword_damage;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(@Nonnull EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.m_41720_() == ModItems.alfsteelIngot || !Ingredient.m_204132_((TagKey)ModTags.Items.INGOTS_TERRASTEEL).test(repair) && super.m_6832_(toRepair, repair);
    }

    @Override
    public boolean canRepairPylon(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return (int)(2.5 * (double)this.getManaPerDamage());
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.m_41721_(Math.max(0, stack.m_41773_() - 5));
        return stack;
    }

    public EntityManaBurst getAlfBurst(Player player, ItemStack stack) {
        EntityManaBurst burst = ItemTerraSword.getBurst((Player)player, (ItemStack)stack);
        burst.setColor(16224512);
        burst.setMana(this.getManaPerDamage());
        burst.setStartingMana(this.getManaPerDamage());
        burst.setMinManaLoss(20);
        burst.setManaLossPerTick(2.0f);
        return burst;
    }

    public void trySpawnAlfBurst(Player player) {
        if (player.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == ModItems.alfsteelSword && player.m_36403_(0.0f) == 1.0f) {
            EntityManaBurst burst = this.getAlfBurst(player, player.m_21205_());
            player.f_19853_.m_7967_((Entity)burst);
            player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.terraBlade, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void updateBurst(IManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        AABB aabb = new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82400_(1.0);
        Entity thrower = entity.m_37282_();
        List entities = entity.f_19853_.m_45976_(LivingEntity.class, aabb);
        for (LivingEntity living : entities) {
            int mana;
            if (living == thrower) continue;
            if (living instanceof Player) {
                Player throwingPlayer;
                Player livingPlayer = (Player)living;
                if (thrower instanceof Player && !(throwingPlayer = (Player)thrower).m_7099_(livingPlayer)) continue;
            }
            if (living.f_20916_ != 0 || (mana = burst.getMana()) < 33) continue;
            burst.setMana(mana - 33);
            float damage = 4.0f + this.m_43299_();
            if (burst.isFake() || entity.f_19853_.f_46443_) continue;
            DamageSource source = DamageSource.f_19319_;
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                source = DamageSource.m_19344_((Player)player);
            } else if (thrower instanceof LivingEntity) {
                LivingEntity livingThrower = (LivingEntity)thrower;
                source = DamageSource.m_19370_((LivingEntity)livingThrower);
            }
            living.m_6469_(source, damage);
            if (burst.getMana() > 0) continue;
            entity.m_146870_();
        }
    }
}

