/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import com.google.common.collect.Multimap;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mythicbotany.ModItems;
import mythicbotany.MythicBotany;
import mythicbotany.alftools.CommonAlfsteelArmor;
import mythicbotany.config.MythicConfig;
import mythicbotany.pylon.PylonRepairable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelHelm;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ModTags;

public class AlfsteelHelm
extends ItemTerrasteelHelm
implements PylonRepairable {
    private static final LazyValue<ItemStack[]> armorSet = new LazyValue(() -> new ItemStack[]{new ItemStack((ItemLike)ModItems.alfsteelHelmet), new ItemStack((ItemLike)ModItems.alfsteelChestplate), new ItemStack((ItemLike)ModItems.alfsteelLeggings), new ItemStack((ItemLike)ModItems.alfsteelBoots)});

    public AlfsteelHelm(Item.Properties props) {
        super(props.m_41503_(MythicConfig.alftools.durability.armor.max_durability()));
    }

    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return MythicBotany.getInstance().modid + ":textures/model/armor_alfsteel.png";
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(@Nonnull EquipmentSlot slot) {
        return CommonAlfsteelArmor.applyModifiers((ItemTerrasteelArmor)this, (Multimap<Attribute, AttributeModifier>)super.m_7167_(slot), slot);
    }

    public int getManaPerDamage() {
        return MythicConfig.alftools.durability.armor.mana_per_durability();
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_ && stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, this.getManaPerDamage() * 2, true)) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible((ItemStack)stack, (int)amount, entity, (int)this.getManaPerDamage());
    }

    public ItemStack[] getArmorSetStacks() {
        return (ItemStack[])armorSet.get();
    }

    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        return CommonAlfsteelArmor.hasArmorSetItem(player, slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        super.addArmorSetDescription(stack, list);
        CommonAlfsteelArmor.addArmorSetDescription(stack, list);
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.m_41720_() == ModItems.alfsteelIngot || !Ingredient.m_204132_((TagKey)ModTags.Items.INGOTS_TERRASTEEL).test(repair) && super.m_6832_(toRepair, repair);
    }

    @Override
    public boolean canRepairPylon(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return (int)(2.5 * (double)this.getManaPerDamage());
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.m_41721_(Math.max(0, stack.m_41773_() - 5));
        return stack;
    }

    public int m_40404_() {
        return CommonAlfsteelArmor.getDefense(this.m_40402_());
    }

    public float m_40405_() {
        return CommonAlfsteelArmor.getToughness(this.m_40402_());
    }
}

