/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.util;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import mythicbotany.ModBlocks;
import mythicbotany.alfheim.util.HorizontalPos;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.material.Material;

public class AlfheimWorldGenUtil {
    public static <T extends FeatureConfiguration> boolean generateTries(FeaturePlaceContext<T> context, int tries, BiFunction<FeaturePlaceContext<T>, HorizontalPos, Boolean> placeFunc) {
        boolean success = false;
        for (int i = 0; i < tries; ++i) {
            if (!placeFunc.apply(context, new HorizontalPos(context.m_159777_().m_123341_() + context.m_159776_().nextInt(16), context.m_159777_().m_123343_() + context.m_159776_().nextInt(16))).booleanValue()) continue;
            success = true;
        }
        return success;
    }

    public static BlockPos highestFreeBlock(LevelAccessor level, HorizontalPos hor, Predicate<BlockState> passthrough) {
        return hor.trace(level.m_151558_(), level.m_141937_(), pos -> !level.m_46859_(pos) && !passthrough.test(level.m_8055_(pos)));
    }

    public static BlockPos lowestFreeBlock(LevelAccessor level, HorizontalPos hor, Predicate<BlockState> passthrough) {
        return hor.trace(level.m_141937_(), level.m_151558_(), pos -> !level.m_46859_(pos) && !passthrough.test(level.m_8055_(pos)));
    }

    public static boolean passReplaceableAndLeaves(BlockState state) {
        return state.m_60767_().m_76336_() && state.m_60767_() != Material.f_76305_ && state.m_60767_() != Material.f_76307_ || state.m_60767_() == Material.f_76274_;
    }

    public static boolean passReplaceableAndDreamWood(BlockState state) {
        return AlfheimWorldGenUtil.passReplaceableAndLeaves(state) || state.m_60734_() == ModBlocks.dreamwoodLeaves || state.m_60734_() == vazkii.botania.common.block.ModBlocks.dreamwood;
    }

    public static Predicate<BlockState> passNoCrops(Predicate<BlockState> test) {
        return state -> test.test((BlockState)state) && !(state.m_60734_() instanceof CropBlock);
    }
}

