/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.structure.piece;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.noeppi_noeppi.libx.fi.Function3;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mythicbotany.MythicBotany;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class BaseStructurePiece
extends SinglePoolElement {
    public static <T extends BaseStructurePiece> Codec<T> codec(Function3<Either<ResourceLocation, StructureTemplate>, Holder<StructureProcessorList>, StructureTemplatePool.Projection, T> ctor) {
        return RecordCodecBuilder.create(builder -> builder.group((App)BaseStructurePiece.m_210465_(), (App)BaseStructurePiece.m_210462_(), (App)BaseStructurePiece.m_210538_()).apply((Applicative)builder, (arg_0, arg_1, arg_2) -> ((Function3)ctor).apply(arg_0, arg_1, arg_2)));
    }

    public static <T extends BaseStructurePiece> StructurePoolElementType<T> type(Function3<Either<ResourceLocation, StructureTemplate>, Holder<StructureProcessorList>, StructureTemplatePool.Projection, T> ctor) {
        Codec codec = BaseStructurePiece.codec(ctor);
        return () -> codec;
    }

    protected BaseStructurePiece(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> processors, StructureTemplatePool.Projection projection) {
        super(template, processors, projection);
    }

    public boolean m_207251_(@Nonnull StructureManager templates, @Nonnull WorldGenLevel level, @Nonnull StructureFeatureManager structures, @Nonnull ChunkGenerator generator, @Nonnull BlockPos pos, @Nonnull BlockPos processorPos, @Nonnull Rotation rot, @Nonnull BoundingBox box, @Nonnull Random random, boolean jigsaw) {
        Vec3i offset = this.placementOffset(level, generator);
        StructureTemplate template = (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureManager)templates).m_74341_(arg_0), Function.identity());
        StructurePlaceSettings settings = this.m_207169_(rot, box, jigsaw);
        if (!template.m_74536_((ServerLevelAccessor)level, pos.m_141952_(offset), processorPos.m_141952_(offset), settings, random, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo info : StructureTemplate.processBlockInfos((LevelAccessor)level, (BlockPos)pos.m_141952_(offset), (BlockPos)processorPos.m_141952_(offset), (StructurePlaceSettings)settings, (List)this.m_210457_(templates, pos.m_141952_(offset), rot, false), (StructureTemplate)template)) {
            this.handleCustomDataMarker(templates, structures, level, info, info.f_74675_, rot, random, box);
        }
        return true;
    }

    @Nonnull
    protected StructurePlaceSettings m_207169_(@Nonnull Rotation rot, @Nonnull BoundingBox box, boolean jigsaw) {
        StructurePlaceSettings settings = super.m_207169_(rot, box, jigsaw);
        settings.m_74397_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        return settings;
    }

    public void handleCustomDataMarker(StructureManager templates, StructureFeatureManager structures, WorldGenLevel level, StructureTemplate.StructureBlockInfo block, BlockPos pos, Rotation rot, Random random, BoundingBox box) {
        String data = block.f_74677_ == null ? "" : block.f_74677_.m_128461_("metadata");
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        this.onDataMarker(data, templates, structures, level, block, pos, rot, random, box);
        super.m_210472_((LevelAccessor)level, block, pos, rot, random, box);
    }

    @Nonnull
    public abstract StructurePoolElementType<?> m_207234_();

    protected void onDataMarker(String name, StructureManager templates, StructureFeatureManager structures, WorldGenLevel level, StructureTemplate.StructureBlockInfo block, BlockPos pos, Rotation rot, Random random, BoundingBox box) {
    }

    protected Vec3i placementOffset(WorldGenLevel level, ChunkGenerator generator) {
        return Vec3i.f_123288_;
    }

    protected final void placePiece(StructureManager templates, WorldGenLevel level, String name, BlockPos pos, Random random) {
        StructureTemplate template = templates.m_74341_(MythicBotany.getInstance().resource("parts/" + name));
        template.m_74536_((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings(), random, 4);
    }

    protected final void addEntity(WorldGenLevel level, Entity entity) {
        if (level instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)level;
            int x = (int)Math.floor(entity.m_20185_()) >> 4;
            int z = (int)Math.floor(entity.m_20189_()) >> 4;
            if (region.m_143488_().f_45578_ == x && region.m_143488_().f_45579_ == z) {
                level.m_7967_(entity);
            }
        } else {
            level.m_7967_(entity);
        }
    }
}

