/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.placement;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class AlfheimModifiers {
    public static final List<PlacementModifier> metamorphicStone = List.of(InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158929_()));
    public static final List<PlacementModifier> trees = List.of(InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR), AlfheimModifiers.onGroundFor(Blocks.f_50746_), BiomeFilter.m_191561_());
    public static final List<PlacementModifier> looseTrees = ImmutableList.builder().add((Object)RarityFilter.m_191900_((int)10)).addAll(trees).build();
    public static final List<PlacementModifier> denseTrees = ImmutableList.builder().add((Object)PlacementUtils.m_195364_((int)2, (float)0.1f, (int)1)).addAll(trees).build();
    public static final List<PlacementModifier> vegetation = List.of(CountPlacement.m_191628_((int)15), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());

    public static List<PlacementModifier> ore(int count, VerticalAnchor min, VerticalAnchor max) {
        ImmutableList.Builder list = ImmutableList.builder();
        if (count > 1) {
            list.add((Object)CountPlacement.m_191628_((int)count));
        }
        list.add((Object)InSquarePlacement.m_191715_());
        list.add((Object)HeightRangePlacement.m_191692_((VerticalAnchor)min, (VerticalAnchor)max));
        return list.build();
    }

    private static PlacementModifier onGroundFor(Block block) {
        return AlfheimModifiers.onGroundFor(block.m_49966_());
    }

    private static PlacementModifier onGroundFor(BlockState state) {
        return BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190399_((BlockState)state, (Vec3i)BlockPos.f_121853_), (BlockPredicate)BlockPredicate.m_190407_((Fluid)Fluids.f_76191_, (Vec3i)BlockPos.f_121853_)));
    }
}

