/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.gen;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Climate;

public class AlfheimClimateModifier {
    private final NoiseParameterRange temperature;
    private final NoiseParameterRange humidity;
    private final NoiseParameterRange continentalness;
    private final NoiseParameterRange erosion;
    private final NoiseParameterRange depth;
    private final NoiseParameterRange weirdness;

    public AlfheimClimateModifier(List<Climate.ParameterPoint> biomeData) {
        this.temperature = AlfheimClimateModifier.build("temperature", biomeData, 1.0, Climate.ParameterPoint::f_186863_);
        this.humidity = AlfheimClimateModifier.build("humidity", biomeData, 1.0, Climate.ParameterPoint::f_186864_);
        this.continentalness = AlfheimClimateModifier.build("continentalness", biomeData, 7.0, Climate.ParameterPoint::f_186865_);
        this.erosion = AlfheimClimateModifier.build("erosion", biomeData, 1.0, Climate.ParameterPoint::f_186866_);
        this.depth = AlfheimClimateModifier.build("depth", biomeData, 0.25, Climate.ParameterPoint::f_186867_);
        this.weirdness = AlfheimClimateModifier.build("weirdness", biomeData, 2.5, Climate.ParameterPoint::f_186868_);
    }

    public Climate.TargetPoint modify(Climate.TargetPoint target) {
        return new Climate.TargetPoint(this.temperature.modify(target.f_187003_()), this.humidity.modify(target.f_187004_()), this.continentalness.modify(target.f_187005_()), this.erosion.modify(target.f_187006_()), this.depth.modify(target.f_187007_()), this.weirdness.modify(target.f_187008_()));
    }

    private static NoiseParameterRange build(String name, List<Climate.ParameterPoint> biomeData, double bias, Function<Climate.ParameterPoint, Climate.Parameter> extractor) {
        long max;
        List<Climate.Parameter> params = biomeData.stream().map(extractor).toList();
        long min = params.stream().map(Climate.Parameter::f_186813_).min(Comparator.comparingLong(l -> l)).orElse(-10000L);
        if (min == (max = params.stream().map(Climate.Parameter::f_186814_).max(Comparator.comparingLong(l -> l)).orElse(10000L).longValue())) {
            throw new IllegalStateException("Fixed value in climate value: " + name + ". Alfheim can't generate.");
        }
        return new NoiseParameterRange(Math.min(min, max), Math.max(min, max), bias);
    }

    private record NoiseParameterRange(long min, long max, double bias) {
        public long modify(long value) {
            if (this.min() == this.max()) {
                return this.min();
            }
            return Mth.m_14053_((long)Math.round((double)this.min() + (double)(this.max() - this.min()) * Math.pow((double)(value + 10000L) / 20000.0, this.bias())), (long)this.min(), (long)this.max());
        }
    }
}

