/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mythicbotany.alfheim.Alfheim;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import vazkii.botania.common.block.ModBlocks;

public class AlfheimChunkGenerator {
    public static final Codec<Generator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(generator -> generator.f_207955_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(generator -> generator.f_188604_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(s -> s.biomeRegistry), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(ChunkGenerator::m_62218_), (App)Codec.LONG.fieldOf("seed").orElse((Object)0L).forGetter(generator -> generator.f_64333_)).apply((Applicative)instance, instance.stable(Generator::new)));

    private static NoiseGeneratorSettings generatorSettings() {
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)NoiseGeneratorSettings.m_204599_().m_203334_();
        return new NoiseGeneratorSettings(AlfheimChunkGenerator.withSampling(settings.f_64439_()), ModBlocks.livingrock.m_49966_(), Blocks.f_49990_.m_49966_(), settings.f_209353_(), Alfheim.buildAlfheimSurface(), settings.f_64444_(), settings.f_64445_(), settings.m_158567_(), false, settings.f_209354_());
    }

    private static NoiseSettings withSampling(NoiseSettings settings) {
        NoiseSamplingSettings sampling = new NoiseSamplingSettings(1.2, 18.0, 80.0, 120.0);
        return new NoiseSettings(settings.f_158688_(), settings.f_64508_(), sampling, settings.f_64510_(), settings.f_64511_(), settings.f_64512_(), settings.f_64513_(), settings.f_189186_());
    }

    private static class Generator
    extends NoiseBasedChunkGenerator {
        private final Registry<Biome> biomeRegistry;
        private final HolderSet<StructureSet> structureSettings;

        public Generator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, Registry<Biome> biomeRegistry, BiomeSource biomeSource, long seed) {
            super(structureSets, noises, biomeSource, seed, Holder.m_205709_((Object)AlfheimChunkGenerator.generatorSettings()));
            this.biomeRegistry = biomeRegistry;
            this.structureSettings = HolderSet.m_205800_(structureSets.m_203611_().filter(Alfheim.buildAlfheimStructures(biomeRegistry)).toList());
        }

        @Nonnull
        protected Codec<? extends ChunkGenerator> m_6909_() {
            return CODEC;
        }

        @Nonnull
        public Generator withSeed(long seed) {
            return new Generator((Registry<StructureSet>)this.f_207955_, (Registry<NormalNoise.NoiseParameters>)this.f_188604_, this.biomeRegistry, this.f_62137_, seed);
        }

        @Nonnull
        public Stream<Holder<StructureSet>> m_207969_() {
            return this.structureSettings.m_203614_();
        }
    }
}

