/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.alfheim.Alfheim;
import mythicbotany.alfheim.gen.AlfheimClimateModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;

public class AlfheimBiomeSource {
    public static final Codec<Source> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(s -> s.biomeRegistry)).apply((Applicative)instance, instance.stable(AlfheimBiomeSource::createSource)));

    private static Source createSource(Registry<Biome> biomeRegistry) {
        return new Source(biomeRegistry, AlfheimBiomeSource.parameters(biomeRegistry), AlfheimBiomeSource.preset(biomeRegistry));
    }

    private static Climate.ParameterList<Holder<Biome>> parameters(Registry<Biome> biomeRegistry) {
        return Alfheim.buildAlfheimClimate(arg_0 -> biomeRegistry.m_203636_(arg_0));
    }

    private static MultiNoiseBiomeSource.PresetInstance preset(Registry<Biome> biomeRegistry) {
        return new MultiNoiseBiomeSource.PresetInstance(new MultiNoiseBiomeSource.Preset(Alfheim.DIMENSION.m_135782_(), AlfheimBiomeSource::parameters), biomeRegistry);
    }

    public static class Source
    extends MultiNoiseBiomeSource {
        private final Registry<Biome> biomeRegistry;
        private final AlfheimClimateModifier modifier;

        public Source(Registry<Biome> biomeRegistry, Climate.ParameterList<Holder<Biome>> parameters, @Nullable MultiNoiseBiomeSource.PresetInstance preset) {
            super(parameters, Optional.ofNullable(preset));
            this.biomeRegistry = biomeRegistry;
            this.modifier = new AlfheimClimateModifier(Alfheim.buildAllClimateParameters());
        }

        @Nonnull
        protected Codec<? extends BiomeSource> m_5820_() {
            return CODEC;
        }

        @Nonnull
        public Holder<Biome> m_204269_(@Nonnull Climate.TargetPoint target) {
            return super.m_204269_(this.modifier.modify(target));
        }

        public void m_207301_(@Nonnull List<String> list, @Nonnull BlockPos pos, @Nonnull Climate.Sampler sampler) {
            super.m_207301_(list, pos, sampler);
            int x = QuartPos.m_175400_((int)pos.m_123341_());
            int y = QuartPos.m_175400_((int)pos.m_123342_());
            int z = QuartPos.m_175400_((int)pos.m_123343_());
            Climate.TargetPoint target = sampler.m_183445_(x, y, z);
            DecimalFormat format = new DecimalFormat("0.000");
            list.add("multinoise-depth: " + format.format(Climate.m_186796_((long)target.f_187008_())));
            target = this.modifier.modify(target);
            list.add("Alfheim Noise: C: " + format.format(Climate.m_186796_((long)target.f_187005_())) + " E: " + format.format(Climate.m_186796_((long)target.f_187006_())) + " T: " + format.format(Climate.m_186796_((long)target.f_187003_())) + " H: " + format.format(Climate.m_186796_((long)target.f_187004_())) + " W: " + format.format(Climate.m_186796_((long)target.f_187008_())) + " D: " + format.format(Climate.m_186796_((long)target.f_187007_())));
        }
    }
}

