/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.featuregen;

import com.mojang.serialization.Codec;
import io.github.noeppi_noeppi.libx.annotation.api.Codecs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import mythicbotany.ModBlockTags;
import mythicbotany.MythicBotany;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.Material;

public class ShatteredTrunkPlacer
extends TrunkPlacer {
    public static final Codec<ShatteredTrunkPlacer> CODEC = Codecs.get(MythicBotany.class, ShatteredTrunkPlacer.class);
    public static final TrunkPlacerType<ShatteredTrunkPlacer> TYPE = new TrunkPlacerType(CODEC);

    public ShatteredTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @Nonnull
    protected TrunkPlacerType<?> m_7362_() {
        return TYPE;
    }

    @Nonnull
    public List<FoliagePlacer.FoliageAttachment> m_142625_(@Nonnull LevelSimulatedReader level, @Nonnull BiConsumer<BlockPos, BlockState> blockSetter, @Nonnull Random random, int freeTreeHeight, BlockPos pos, @Nonnull TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> list = new ArrayList<FoliagePlacer.FoliageAttachment>();
        ShatteredTrunkPlacer.m_161880_((LevelSimulatedReader)level, blockSetter, (Random)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        for (Direction dir : Direction.values()) {
            if (dir.m_122434_() == Direction.Axis.Y || random.nextInt(3) != 0) continue;
            BlockPos.MutableBlockPos mpos = pos.m_142300_(Direction.UP).m_142300_(dir).m_122032_();
            for (int i = 0; i < 3; ++i) {
                mpos.m_122184_(0, -1, 0);
                if (!this.placeLog(level, blockSetter, (BlockPos)mpos, random, config)) break;
            }
            if (!level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60815_)) continue;
            ShatteredTrunkPlacer.m_161880_((LevelSimulatedReader)level, blockSetter, (Random)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        }
        int straightTrunkSize = Math.max(3, freeTreeHeight - 3);
        for (int i = 0; i < straightTrunkSize; ++i) {
            this.placeLog(level, blockSetter, pos.m_6630_(i), random, config);
        }
        int shatters = 3 + random.nextInt(3);
        block3: for (int i = 0; i < shatters; ++i) {
            int xd = random.nextInt(3);
            int zd = random.nextInt(3);
            int xs = random.nextBoolean() ? 1 : -1;
            int zs = random.nextBoolean() ? 1 : -1;
            BlockPos.MutableBlockPos mpos = pos.m_6630_(straightTrunkSize - 1).m_122032_();
            int shatterSize = 3 + random.nextInt(4);
            for (int j = 0; j < shatterSize; ++j) {
                int xm = xd == 0 ? 0 : xd / 2 + random.nextInt((xd + 1) / 2);
                int zm = zd == 0 ? 0 : zd / 2 + random.nextInt((zd + 1) / 2);
                int x = 0;
                int z = 0;
                while (x < xm || z < zm) {
                    mpos.m_122184_(x < xm ? xs : 0, random.nextInt(3) != 0 ? 1 : 0, z < zm ? zs : 0);
                    x = Math.min(xm, x + 1);
                    z = Math.min(zm, z + 1);
                    if (!this.placeLog(level, blockSetter, (BlockPos)mpos, random, config)) continue block3;
                    list.add(new FoliagePlacer.FoliageAttachment(mpos.m_7949_(), 0, false));
                }
            }
        }
        return list;
    }

    private boolean placeLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, Random rand, TreeConfiguration config) {
        if (level.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(ModBlockTags.ALFHEIM_LEAVES) || state.m_60767_() == Material.f_76302_ || state.m_60713_(Blocks.f_49990_))) {
            blockSetter.accept(pos, config.f_68185_.m_7112_(rand, pos));
            return true;
        }
        return false;
    }

    public int getBaseHeight() {
        return this.f_70263_;
    }

    public int getHeightRandA() {
        return this.f_70264_;
    }

    public int getHeightRandB() {
        return this.f_70265_;
    }
}

