/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.feature;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import mythicbotany.alfheim.util.AlfheimWorldGenUtil;
import mythicbotany.alfheim.util.HorizontalPos;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.item.ModItems;

public class AbandonedApothecaryFeature
extends Feature<NoneFeatureConfiguration> {
    private static final List<BlockState> STATES = ImmutableList.of((Object)ModBlocks.defaultAltar.m_49966_(), (Object)ModBlocks.forestAltar.m_49966_(), (Object)ModBlocks.plainsAltar.m_49966_(), (Object)ModBlocks.mountainAltar.m_49966_(), (Object)ModBlocks.fungalAltar.m_49966_(), (Object)ModBlocks.swampAltar.m_49966_(), (Object)ModBlocks.desertAltar.m_49966_(), (Object)ModBlocks.taigaAltar.m_49966_(), (Object)ModBlocks.mesaAltar.m_49966_(), (Object)ModBlocks.mossyAltar.m_49966_());
    private static final List<Item> PETALS = ImmutableList.of((Object)ModItems.whitePetal, (Object)ModItems.orangePetal, (Object)ModItems.magentaPetal, (Object)ModItems.lightBluePetal, (Object)ModItems.yellowPetal, (Object)ModItems.limePetal, (Object)ModItems.pinkPetal, (Object)ModItems.grayPetal, (Object)ModItems.lightGrayPetal, (Object)ModItems.cyanPetal, (Object)ModItems.purplePetal, (Object)ModItems.bluePetal, (Object[])new Item[]{ModItems.brownPetal, ModItems.greenPetal, ModItems.redPetal, ModItems.blackPetal});

    public AbandonedApothecaryFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(@Nonnull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (context.m_159776_().nextInt(3) == 0) {
            return AlfheimWorldGenUtil.generateTries(context, 1, this::tryGenerate);
        }
        return false;
    }

    private boolean tryGenerate(FeaturePlaceContext<NoneFeatureConfiguration> context, HorizontalPos hor) {
        BlockPos pos = AlfheimWorldGenUtil.highestFreeBlock((LevelAccessor)context.m_159774_(), hor, AlfheimWorldGenUtil::passReplaceableAndDreamWood);
        if (context.m_159774_().m_8055_(pos.m_7495_()).m_60815_() && context.m_159774_().m_8055_(pos.m_7494_()).m_60795_()) {
            BlockState state = STATES.get(context.m_159776_().nextInt(STATES.size()));
            if (context.m_159776_().nextInt(30) == 0) {
                return context.m_159774_().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.LAVA), 2);
            }
            if (context.m_159776_().nextInt(4) != 0) {
                if (!context.m_159774_().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.WATER), 2)) {
                    return false;
                }
                try {
                    BlockEntity be = context.m_159774_().m_7702_(pos);
                    if (be instanceof TileAltar) {
                        be.f_58856_ = (BlockState)state.m_61124_((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.WATER);
                        int petals = context.m_159776_().nextInt(5);
                        for (int i = 0; i < petals; ++i) {
                            ((TileAltar)be).getItemHandler().m_6836_(i, new ItemStack((ItemLike)PETALS.get(context.m_159776_().nextInt(PETALS.size()))));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            return context.m_159774_().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.EMPTY), 2);
        }
        return false;
    }
}

