/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim;

import java.util.function.Consumer;
import mythicbotany.alfheim.surface.BiomeTemplates;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class BiomeConfiguration {
    private Climate.Parameter temperature = Climate.Parameter.m_186822_((float)0.89f, (float)0.91f);
    private Climate.Parameter humidity = Climate.Parameter.m_186822_((float)0.89f, (float)0.91f);
    private Climate.Parameter continentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.06f);
    private Climate.Parameter erosion = Climate.Parameter.m_186822_((float)-0.2f, (float)0.2f);
    private Climate.Parameter depth = Climate.Parameter.m_186822_((float)0.025f, (float)0.05f);
    private Climate.Parameter weirdness = Climate.Parameter.m_186822_((float)-0.2f, (float)0.2f);
    private SurfaceRules.RuleSource surface = BiomeConfiguration.normalAlfheimSurface(Blocks.f_50440_, Blocks.f_50493_);

    public BiomeConfiguration() {
    }

    public BiomeConfiguration(Template template) {
        template.action.accept(this);
    }

    public BiomeConfiguration temperature(float value) {
        this.temperature = Climate.Parameter.m_186820_((float)value);
        return this;
    }

    public BiomeConfiguration temperature(float min, float max) {
        this.temperature = Climate.Parameter.m_186822_((float)min, (float)max);
        return this;
    }

    public BiomeConfiguration humidity(float value) {
        this.humidity = Climate.Parameter.m_186820_((float)value);
        return this;
    }

    public BiomeConfiguration humidity(float min, float max) {
        this.humidity = Climate.Parameter.m_186822_((float)min, (float)max);
        return this;
    }

    public BiomeConfiguration continentalness(float value) {
        this.continentalness = Climate.Parameter.m_186820_((float)value);
        return this;
    }

    public BiomeConfiguration continentalness(float min, float max) {
        this.continentalness = Climate.Parameter.m_186822_((float)min, (float)max);
        return this;
    }

    public BiomeConfiguration erosion(float value) {
        this.erosion = Climate.Parameter.m_186820_((float)value);
        return this;
    }

    public BiomeConfiguration erosion(float min, float max) {
        this.erosion = Climate.Parameter.m_186822_((float)min, (float)max);
        return this;
    }

    public BiomeConfiguration depth(float value) {
        this.depth = Climate.Parameter.m_186820_((float)value);
        return this;
    }

    public BiomeConfiguration depth(float min, float max) {
        this.depth = Climate.Parameter.m_186822_((float)min, (float)max);
        return this;
    }

    public BiomeConfiguration weirdness(float value) {
        this.weirdness = Climate.Parameter.m_186820_((float)value);
        return this;
    }

    public BiomeConfiguration weirdness(float min, float max) {
        this.weirdness = Climate.Parameter.m_186822_((float)min, (float)max);
        return this;
    }

    public BiomeConfiguration surface(Block top, Block below) {
        return this.surface(BiomeConfiguration.normalAlfheimSurface(top, below));
    }

    public BiomeConfiguration surface(BlockState top, BlockState below) {
        return this.surface(BiomeConfiguration.normalAlfheimSurface(top, below));
    }

    public BiomeConfiguration surface(SurfaceRules.RuleSource rule) {
        this.surface = rule;
        return this;
    }

    public Climate.ParameterPoint buildClimate() {
        return new Climate.ParameterPoint(this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, 0L);
    }

    public SurfaceRules.RuleSource buildSurface() {
        return this.surface;
    }

    public static SurfaceRules.RuleSource normalAlfheimSurface(Block top, Block below) {
        return BiomeConfiguration.normalAlfheimSurface(top.m_49966_(), below.m_49966_());
    }

    public static SurfaceRules.RuleSource normalAlfheimSurface(BlockState top, BlockState below) {
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)60), (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0)), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)below)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)top)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189381_()), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)below))}))}))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)60), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0)), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)below)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189381_()), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)below))}))})))});
    }

    public static enum Template {
        DEFAULT(gen -> {}),
        OCEAN(BiomeTemplates::ocean),
        LAKE(BiomeTemplates::lake),
        FLAT(BiomeTemplates::flat),
        MODERATE(BiomeTemplates::moderate),
        HILLS(BiomeTemplates::hills),
        MOUNTAINS(BiomeTemplates::mountains);

        private final Consumer<BiomeConfiguration> action;

        private Template(Consumer<BiomeConfiguration> action) {
            this.action = action;
        }
    }
}

