/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mythicbotany.MythicBotany;
import mythicbotany.alfheim.BiomeConfiguration;
import mythicbotany.alfheim.gen.AlfheimBiomeSource;
import mythicbotany.alfheim.gen.AlfheimChunkGenerator;
import mythicbotany.alfheim.surface.AlfheimSurfaceBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Alfheim {
    public static final ResourceKey<Level> DIMENSION = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)MythicBotany.getInstance().resource("alfheim"));
    public static final BiomeDictionary.Type BIOME_TYPE = BiomeDictionary.Type.getType((String)(MythicBotany.getInstance().modid + "_alfheim"), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    private static final Object LOCK = new Object();
    private static final Map<ResourceKey<Biome>, Climate.ParameterPoint> BIOMES = new HashMap<ResourceKey<Biome>, Climate.ParameterPoint>();
    private static final Map<ResourceKey<Biome>, SurfaceRules.RuleSource> BIOME_SURFACE = new HashMap<ResourceKey<Biome>, SurfaceRules.RuleSource>();
    private static final Set<StructureSet> STRUCTURES = new HashSet<StructureSet>();
    private static final Set<Holder<StructureSet>> STRUCTURE_HOLDERS = new HashSet<Holder<StructureSet>>();

    public static void register() {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)DIMENSION.m_135782_(), AlfheimChunkGenerator.CODEC);
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)DIMENSION.m_135782_(), AlfheimBiomeSource.CODEC);
    }

    public static void addBiome(Biome biome, BiomeConfiguration settings) {
        Alfheim.addBiome(Alfheim.biomeKey(biome), settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBiome(ResourceKey<Biome> biome, BiomeConfiguration settings) {
        Object object = LOCK;
        synchronized (object) {
            if (BIOMES.containsKey(biome)) {
                throw new IllegalStateException("Biome registered twice in alfheim: " + biome);
            }
            BIOMES.put(biome, settings.buildClimate());
            BIOME_SURFACE.put(biome, settings.buildSurface());
            BiomeDictionary.addTypes(biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BIOME_TYPE});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStructure(Holder<StructureSet> structure) {
        Object object = LOCK;
        synchronized (object) {
            if (STRUCTURES.contains(structure.m_203334_())) {
                throw new IllegalStateException("Structure registered twice in alfheim: " + structure);
            }
            STRUCTURES.add((StructureSet)structure.m_203334_());
            STRUCTURE_HOLDERS.add(structure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Climate.ParameterPoint> buildAllClimateParameters() {
        Object object = LOCK;
        synchronized (object) {
            return BIOMES.values().stream().toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Climate.ParameterList<Holder<Biome>> buildAlfheimClimate(Function<ResourceKey<Biome>, Optional<Holder<Biome>>> biomeResolver) {
        Object object = LOCK;
        synchronized (object) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (Map.Entry<ResourceKey<Biome>, Climate.ParameterPoint> entry : Alfheim.biomes(BIOMES)) {
                ResourceKey<Biome> key = entry.getKey();
                list.add((Object)new Pair((Object)entry.getValue(), biomeResolver.apply(key).orElseThrow(() -> new NoSuchElementException("Alfheim biome not registered: " + key))));
            }
            return new Climate.ParameterList((List)list.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SurfaceRules.RuleSource buildAlfheimSurface() {
        Object object = LOCK;
        synchronized (object) {
            ImmutableList.Builder sequence = ImmutableList.builder();
            for (Map.Entry<ResourceKey<Biome>, SurfaceRules.RuleSource> entry : Alfheim.biomes(BIOME_SURFACE)) {
                sequence.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{entry.getKey()}), (SurfaceRules.RuleSource)entry.getValue()));
            }
            return AlfheimSurfaceBuilder.buildSurface(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])sequence.build().toArray((Object[])new SurfaceRules.RuleSource[0]))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Predicate<Holder<StructureSet>> buildAlfheimStructures(Registry<Biome> biomeRegistry) {
        Object object = LOCK;
        synchronized (object) {
            Set keys = Set.copyOf(STRUCTURE_HOLDERS).stream().map(holder -> (ResourceKey)holder.m_203543_().orElseThrow(() -> new IllegalStateException("Alfheim structure with direct holder detected: " + holder + ", this is not allowed."))).collect(Collectors.toUnmodifiableSet());
            return holder -> keys.stream().anyMatch(arg_0 -> ((Holder)holder).m_203565_(arg_0));
        }
    }

    private static ResourceKey<Biome> biomeKey(Biome biome) {
        Optional key = ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome);
        if (key != null && key.isPresent()) {
            return (ResourceKey)key.get();
        }
        throw new IllegalStateException("Biome not registered: " + biome.getRegistryName() + ": " + biome);
    }

    private static List<ResourceKey<Biome>> biomeKeys(List<Biome> biomes) {
        return biomes.stream().map(Alfheim::biomeKey).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<Map.Entry<ResourceKey<Biome>, T>> biomes(Map<ResourceKey<Biome>, T> map) {
        Object object = LOCK;
        synchronized (object) {
            return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        }
    }

    private record StructureSettings(int weight, StructurePlacement placement) {
    }
}

