/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import mythicbotany.MythicBotany;
import mythicbotany.config.MythicConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeRemover {
    public static final ResourceLocation GAIA_PYLON = new ResourceLocation("botania", "gaia_pylon");
    public static final ResourceLocation HARD_PYLON = MythicBotany.getInstance().resource("gaia_pylon");

    private RecipeRemover() {
    }

    public static void removeRecipes(RecipeManager rm) {
        Map byIdMap;
        HashSet<ResourceLocation> recipesToRemove = new HashSet<ResourceLocation>();
        if (MythicConfig.replaceGaiaRecipe) {
            recipesToRemove.add(GAIA_PYLON);
        } else {
            recipesToRemove.add(HARD_PYLON);
        }
        Map recipes = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)rm, (String)"f_44007_");
        if (recipes != null) {
            Map newRecipes = (Map)recipes.entrySet().stream().map(entry -> Pair.of((Object)((RecipeType)entry.getKey()), RecipeRemover.withRecipesRemoved((Map)entry.getValue(), recipesToRemove))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            ObfuscationReflectionHelper.setPrivateValue(RecipeManager.class, (Object)rm, (Object)newRecipes, (String)"f_44007_");
        }
        if ((byIdMap = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)rm, (String)"f_199900_")) != null) {
            ImmutableMap newByIdMap = RecipeRemover.withRecipesRemoved(byIdMap, recipesToRemove);
            ObfuscationReflectionHelper.setPrivateValue(RecipeManager.class, (Object)rm, newByIdMap, (String)"f_199900_");
        }
    }

    private static <T> ImmutableMap<ResourceLocation, T> withRecipesRemoved(Map<ResourceLocation, T> map, Set<ResourceLocation> recipesToRemove) {
        return (ImmutableMap)((Stream)map.entrySet().stream().parallel()).filter(entry -> !recipesToRemove.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

