/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany;

import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.ModXRegistration;
import io.github.noeppi_noeppi.libx.mod.registration.RegistrationBuilder;
import io.github.noeppi_noeppi.libx.mod.registration.RegistryTransformer;
import javax.annotation.Nonnull;
import mythicbotany.EventListener;
import mythicbotany.ModEntities;
import mythicbotany.ModItems;
import mythicbotany.ModMisc;
import mythicbotany.ModRecipes;
import mythicbotany.MythicMappings;
import mythicbotany.RecipeRemover;
import mythicbotany.advancement.ModCriteria;
import mythicbotany.alfheim.Alfheim;
import mythicbotany.alfheim.AlfheimDimension;
import mythicbotany.alfheim.structure.piece.ModStructurePieces;
import mythicbotany.alfheim.teleporter.AlfheimPortalHandler;
import mythicbotany.config.ClientConfig;
import mythicbotany.kvasir.WanderingTraderRuneInput;
import mythicbotany.mjoellnir.MjoellnirRuneOutput;
import mythicbotany.network.MythicNetwork;
import mythicbotany.patchouli.PageRitualInfo;
import mythicbotany.patchouli.PageRitualPattern;
import mythicbotany.pylon.PylonRepairables;
import mythicbotany.register.FeatureTransformer;
import mythicbotany.register.TrunkPlacerTransformer;
import mythicbotany.rune.RuneRitualRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.SlotTypePreset;
import vazkii.patchouli.client.book.ClientBookRegistry;

@Mod(value="mythicbotany")
public final class MythicBotany
extends ModXRegistration {
    public static final Logger logger = LoggerFactory.getLogger((String)"mythicbotany");
    private static MythicBotany instance;
    private static MythicNetwork network;

    public MythicBotany() {
        super(new CreativeModeTab("mythicbotany"){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ModItems.alfsteelSword);
            }
        });
        instance = this;
        network = new MythicNetwork((ModX)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        this.addRegistrationHandler(ModRecipes::register);
        this.addRegistrationHandler(ModMisc::register);
        this.addRegistrationHandler(Alfheim::register);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::createAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, MythicMappings::remapItems);
        MinecraftForge.EVENT_BUS.addGenericListener(Item.class, MythicMappings::remapItems);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        MinecraftForge.EVENT_BUS.addListener(this::datapacksReloaded);
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, AlfheimPortalHandler::renderGameOverlay));
        MinecraftForge.EVENT_BUS.addListener(AlfheimPortalHandler::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(AlfheimPortalHandler::endTick);
    }

    @Nonnull
    public static MythicBotany getInstance() {
        return instance;
    }

    @Nonnull
    public static MythicNetwork getNetwork() {
        return network;
    }

    protected void initRegistration(RegistrationBuilder builder) {
        builder.setVersion(1);
        builder.addTransformer((RegistryTransformer)TrunkPlacerTransformer.INSTANCE);
        builder.addTransformer((RegistryTransformer)FeatureTransformer.INSTANCE);
    }

    protected void setup(FMLCommonSetupEvent event) {
        logger.info("Loading MythicBotany");
        event.enqueueWork(() -> {
            ModStructurePieces.setup();
            ModEntities.setup();
            ModCriteria.setup();
            PylonRepairables.register(new PylonRepairables.ItemPylonRepairable(), 10);
            PylonRepairables.register(new PylonRepairables.MendingPylonRepairable(), -10);
            RuneRitualRecipe.registerSpecialInput(WanderingTraderRuneInput.INSTANCE);
            RuneRitualRecipe.registerSpecialOutput(MjoellnirRuneOutput.INSTANCE);
            AlfheimDimension.setup();
        });
    }

    protected void clientSetup(FMLClientSetupEvent event) {
        ModEntities.clientSetup();
        event.enqueueWork(() -> {
            ClientBookRegistry.INSTANCE.pageTypes.put(new ResourceLocation(this.modid, "ritual_pattern"), PageRitualPattern.class);
            ClientBookRegistry.INSTANCE.pageTypes.put(new ResourceLocation(this.modid, "ritual_info"), PageRitualInfo.class);
        });
    }

    private void sendIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().size(3).build());
        InterModComms.sendTo((String)"apotheosis", (String)"set_ench_hard_cap", () -> new EnchantmentInstance(ModMisc.hammerMobility, 5));
    }

    public void serverStart(ServerStartingEvent event) {
        RecipeRemover.removeRecipes(event.getServer().m_129894_());
    }

    public void datapacksReloaded(OnDatapackSyncEvent event) {
        RecipeRemover.removeRecipes(event.getPlayerList().m_7873_().m_129894_());
    }
}

