/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world.height;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.WorldConfig;
import mekanism.common.registries.MekanismHeightProviderTypes;
import mekanism.common.resource.ore.OreType;
import mekanism.common.world.height.ConfigurableHeightRange;
import mekanism.common.world.height.HeightShape;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;

public class ConfigurableHeightProvider
extends HeightProvider {
    public static final Codec<ConfigurableHeightProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)OreType.OreVeinType.CODEC.fieldOf("oreVeinType").forGetter(config -> config.oreVeinType)).apply((Applicative)builder, type -> new ConfigurableHeightProvider((OreType.OreVeinType)type, MekanismConfig.world.getVeinConfig((OreType.OreVeinType)type))));
    private final OreType.OreVeinType oreVeinType;
    private final ConfigurableHeightRange range;
    private LongSet warnedFor;

    private ConfigurableHeightProvider(OreType.OreVeinType oreVeinType, WorldConfig.OreVeinConfig oreConfig) {
        this.oreVeinType = oreVeinType;
        this.range = oreConfig.range();
    }

    public static ConfigurableHeightProvider of(OreType.OreVeinType type, WorldConfig.OreVeinConfig oreConfig) {
        return new ConfigurableHeightProvider(type, oreConfig);
    }

    public int m_142233_(@Nonnull Random random, @Nonnull WorldGenerationContext context) {
        int max;
        int min = this.range.minInclusive().resolveY(context);
        if (min > (max = this.range.maxInclusive().resolveY(context))) {
            if (this.warnedFor == null) {
                this.warnedFor = new LongOpenHashSet();
            }
            if (this.warnedFor.add((long)min << 32 | (long)max)) {
                Mekanism.logger.warn("Empty height range: {}", (Object)this);
            }
            return min;
        }
        return switch (this.range.shape().get()) {
            default -> throw new IncompatibleClassChangeError();
            case HeightShape.TRAPEZOID -> this.sampleTrapezoid(random, min, max);
            case HeightShape.UNIFORM -> Mth.m_144928_((Random)random, (int)min, (int)max);
        };
    }

    private int sampleTrapezoid(@Nonnull Random random, int min, int max) {
        int range;
        int plateau = this.range.plateau().getAsInt();
        if (plateau >= (range = max - min)) {
            return Mth.m_144928_((Random)random, (int)min, (int)max);
        }
        int middle = (range - plateau) / 2;
        return min + Mth.m_144928_((Random)random, (int)0, (int)(range - middle)) + Mth.m_144928_((Random)random, (int)0, (int)middle);
    }

    @Nonnull
    public HeightProviderType<?> m_142002_() {
        return (HeightProviderType)MekanismHeightProviderTypes.CONFIGURABLE.get();
    }

    public String toString() {
        switch (this.range.shape().get()) {
            case TRAPEZOID: {
                int plateau = this.range.plateau().getAsInt();
                if (plateau == 0) {
                    return this.oreVeinType.name() + " triangle [" + this.range.minInclusive() + "-" + this.range.maxInclusive() + "]";
                }
                return this.oreVeinType.name() + " trapezoid(" + plateau + ") in [" + this.range.minInclusive() + "-" + this.range.maxInclusive() + "]";
            }
            case UNIFORM: {
                return this.oreVeinType.name() + " uniform [" + this.range.minInclusive() + "-" + this.range.maxInclusive() + "]";
            }
        }
        return this.oreVeinType.name();
    }
}

