/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import mekanism.api.IDisableableEnum;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EnumUtils;
import net.minecraft.network.chat.Component;

public class UnitDisplayUtils {
    public static Component getDisplay(FloatingLong value, EnergyUnit unit, int decimalPlaces, boolean isShort) {
        ILangEntry label = unit.pluralLangEntry;
        if (isShort) {
            label = unit.shortLangEntry;
        } else if (value.equals(FloatingLong.ONE)) {
            label = unit.singularLangEntry;
        }
        if (value.isZero()) {
            return TextComponentUtil.build(value + " ", label);
        }
        for (int i = 0; i < EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS.length; ++i) {
            FloatingLongMeasurementUnit lowerMeasure = EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS[i];
            if (i == 0 && lowerMeasure.below(value)) {
                return TextComponentUtil.build(lowerMeasure.process(value).toString(decimalPlaces) + " " + lowerMeasure.getName(isShort), label);
            }
            if (i + 1 >= EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS.length) {
                return TextComponentUtil.build(lowerMeasure.process(value).toString(decimalPlaces) + " " + lowerMeasure.getName(isShort), label);
            }
            FloatingLongMeasurementUnit upperMeasure = EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS[i + 1];
            if ((!lowerMeasure.above(value) || !upperMeasure.below(value)) && !lowerMeasure.value.equals(value)) continue;
            return TextComponentUtil.build(lowerMeasure.process(value).toString(decimalPlaces) + " " + lowerMeasure.getName(isShort), label);
        }
        return TextComponentUtil.build(value.toString(decimalPlaces), label);
    }

    public static Component getDisplayShort(FloatingLong value, EnergyUnit unit) {
        return UnitDisplayUtils.getDisplay(value, unit, 2, true);
    }

    public static Component getDisplay(double temp, TemperatureUnit unit, int decimalPlaces, boolean shift, boolean isShort) {
        return UnitDisplayUtils.getDisplayBase(unit.convertFromK(temp, shift), unit, decimalPlaces, isShort, false);
    }

    public static Component getDisplayBase(double value, Unit unit, int decimalPlaces, boolean isShort, boolean spaceBetweenSymbol) {
        boolean negative;
        String spaceStr;
        ILangEntry label = unit.getLabel();
        String string = spaceStr = spaceBetweenSymbol ? " " : "";
        if (value == 0.0) {
            return isShort ? TextComponentUtil.getString(value + spaceStr + unit.getSymbol()) : TextComponentUtil.build(value, label);
        }
        boolean bl = negative = value < 0.0;
        if (negative) {
            value = Math.abs(value);
        }
        for (int i = 0; i < EnumUtils.MEASUREMENT_UNITS.length; ++i) {
            MeasurementUnit lowerMeasure = EnumUtils.MEASUREMENT_UNITS[i];
            String symbolStr = spaceStr + lowerMeasure.symbol;
            if (lowerMeasure.below(value) && lowerMeasure.ordinal() == 0) {
                if (isShort) {
                    return TextComponentUtil.getString(UnitDisplayUtils.roundDecimals(negative, lowerMeasure.process(value), decimalPlaces) + symbolStr + unit.getSymbol());
                }
                return TextComponentUtil.build(UnitDisplayUtils.roundDecimals(negative, lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.name, label);
            }
            if (lowerMeasure.ordinal() + 1 >= EnumUtils.MEASUREMENT_UNITS.length) {
                if (isShort) {
                    return TextComponentUtil.getString(UnitDisplayUtils.roundDecimals(negative, lowerMeasure.process(value), decimalPlaces) + symbolStr + unit.getSymbol());
                }
                return TextComponentUtil.build(UnitDisplayUtils.roundDecimals(negative, lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.name, label);
            }
            if (i + 1 >= EnumUtils.MEASUREMENT_UNITS.length) continue;
            MeasurementUnit upperMeasure = EnumUtils.MEASUREMENT_UNITS[i + 1];
            if ((!lowerMeasure.above(value) || !upperMeasure.below(value)) && lowerMeasure.value != value) continue;
            if (isShort) {
                return TextComponentUtil.getString(UnitDisplayUtils.roundDecimals(negative, lowerMeasure.process(value), decimalPlaces) + symbolStr + unit.getSymbol());
            }
            return TextComponentUtil.build(UnitDisplayUtils.roundDecimals(negative, lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.name, label);
        }
        if (isShort) {
            return TextComponentUtil.getString(UnitDisplayUtils.roundDecimals(negative, value, decimalPlaces) + spaceStr + unit.getSymbol());
        }
        return TextComponentUtil.build(UnitDisplayUtils.roundDecimals(negative, value, decimalPlaces) + " ", label);
    }

    public static Component getDisplayShort(double value, TemperatureUnit unit) {
        return UnitDisplayUtils.getDisplayShort(value, unit, true);
    }

    public static Component getDisplayShort(double value, TemperatureUnit unit, boolean shift) {
        return UnitDisplayUtils.getDisplayShort(value, unit, shift, 2);
    }

    public static Component getDisplayShort(double value, TemperatureUnit unit, boolean shift, int decimalPlaces) {
        return UnitDisplayUtils.getDisplay(value, unit, decimalPlaces, shift, true);
    }

    public static Component getDisplayShort(double value, RadiationUnit unit, int decimalPlaces) {
        return UnitDisplayUtils.getDisplayBase(value, unit, decimalPlaces, true, true);
    }

    public static double roundDecimals(boolean negative, double d, int decimalPlaces) {
        return negative ? UnitDisplayUtils.roundDecimals(-d, decimalPlaces) : UnitDisplayUtils.roundDecimals(d, decimalPlaces);
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        double multiplier = Math.pow(10.0, decimalPlaces);
        long j = (long)(d * multiplier);
        return (double)j / multiplier;
    }

    public static double roundDecimals(double d) {
        return UnitDisplayUtils.roundDecimals(d, 2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EnergyUnit implements IDisableableEnum<EnergyUnit>,
    IHasTranslationKey
    {
        JOULES(MekanismLang.ENERGY_JOULES, MekanismLang.ENERGY_JOULES_PLURAL, MekanismLang.ENERGY_JOULES_SHORT, "j", () -> true){

            @Override
            protected EnergyConversionRate getConversionRate() {
                return null;
            }

            @Override
            public FloatingLong convertFrom(FloatingLong energy) {
                return energy;
            }

            @Override
            public FloatingLong convertToAsFloatingLong(FloatingLong joules) {
                return joules;
            }
        }
        ,
        FORGE_ENERGY(MekanismLang.ENERGY_FORGE, MekanismLang.ENERGY_FORGE, MekanismLang.ENERGY_FORGE_SHORT, "fe", () -> !MekanismConfig.general.blacklistForge.get()){

            @Override
            protected EnergyConversionRate getConversionRate() {
                return MekanismConfig.general.FORGE_CONVERSION_RATE;
            }
        }
        ,
        ELECTRICAL_UNITS(MekanismLang.ENERGY_EU, MekanismLang.ENERGY_EU_PLURAL, MekanismLang.ENERGY_EU_SHORT, "eu", EnergyCompatUtils::useIC2){

            @Override
            protected EnergyConversionRate getConversionRate() {
                return MekanismConfig.general.IC2_CONVERSION_RATE;
            }
        };

        private static final EnergyUnit[] TYPES;
        private final BooleanSupplier checkEnabled;
        private final ILangEntry singularLangEntry;
        private final ILangEntry pluralLangEntry;
        private final ILangEntry shortLangEntry;
        private final String tabName;

        private EnergyUnit(ILangEntry singularLangEntry, ILangEntry pluralLangEntry, ILangEntry shortLangEntry, String tabName, BooleanSupplier checkEnabled) {
            this.singularLangEntry = singularLangEntry;
            this.pluralLangEntry = pluralLangEntry;
            this.shortLangEntry = shortLangEntry;
            this.checkEnabled = checkEnabled;
            this.tabName = tabName;
        }

        protected abstract EnergyConversionRate getConversionRate();

        public FloatingLong convertFrom(long energy) {
            return this.convertFrom(FloatingLong.createConst(energy));
        }

        public FloatingLong convertFrom(FloatingLong energy) {
            return energy.multiply((FloatingLong)this.getConversionRate().from.get());
        }

        public int convertToAsInt(FloatingLong joules) {
            return this.convertToAsFloatingLong(joules).intValue();
        }

        public long convertToAsLong(FloatingLong joules) {
            return this.convertToAsFloatingLong(joules).longValue();
        }

        public FloatingLong convertToAsFloatingLong(FloatingLong joules) {
            return joules.multiply((FloatingLong)this.getConversionRate().to.get());
        }

        @Override
        public String getTranslationKey() {
            return this.shortLangEntry.getTranslationKey();
        }

        @Override
        @Nonnull
        public EnergyUnit byIndex(int index) {
            return MathUtils.getByIndexMod(TYPES, index);
        }

        public String getTabName() {
            return this.tabName;
        }

        @Override
        public boolean isEnabled() {
            return this.checkEnabled.getAsBoolean();
        }

        public static EnergyUnit getConfigured() {
            EnergyUnit type = (EnergyUnit)MekanismConfig.common.energyUnit.get();
            return type.isEnabled() ? type : JOULES;
        }

        static {
            TYPES = EnergyUnit.values();
        }
    }

    public static enum FloatingLongMeasurementUnit {
        MILLI("Milli", "m", FloatingLong.createConst(0.001)),
        BASE("", "", FloatingLong.ONE),
        KILO("Kilo", "k", FloatingLong.createConst(1000L)),
        MEGA("Mega", "M", FloatingLong.createConst(1000000L)),
        GIGA("Giga", "G", FloatingLong.createConst(1000000000L)),
        TERA("Tera", "T", FloatingLong.createConst(1000000000000L)),
        PETA("Peta", "P", FloatingLong.createConst(1000000000000000L)),
        EXA("Exa", "E", FloatingLong.createConst(1000000000000000000L));

        private final String name;
        private final String symbol;
        private final FloatingLong value;

        private FloatingLongMeasurementUnit(String name, String symbol, FloatingLong value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public FloatingLong process(FloatingLong d) {
            return d.divide(this.value);
        }

        public boolean above(FloatingLong d) {
            return d.greaterThan(this.value);
        }

        public boolean below(FloatingLong d) {
            return d.smallerThan(this.value);
        }
    }

    public static enum TemperatureUnit implements IIncrementalEnum<TemperatureUnit>,
    IHasTranslationKey,
    Unit
    {
        KELVIN(MekanismLang.TEMPERATURE_KELVIN, MekanismLang.TEMPERATURE_KELVIN_SHORT, "K", "k", 0.0, 1.0),
        CELSIUS(MekanismLang.TEMPERATURE_CELSIUS, MekanismLang.TEMPERATURE_CELSIUS_SHORT, "\u00b0C", "c", 273.15, 1.0),
        RANKINE(MekanismLang.TEMPERATURE_RANKINE, MekanismLang.TEMPERATURE_RANKINE_SHORT, "R", "r", 0.0, 1.8),
        FAHRENHEIT(MekanismLang.TEMPERATURE_FAHRENHEIT, MekanismLang.TEMPERATURE_FAHRENHEIT_SHORT, "\u00b0F", "f", 459.67, 1.8),
        AMBIENT(MekanismLang.TEMPERATURE_AMBIENT, MekanismLang.TEMPERATURE_AMBIENT_SHORT, "+STP", "stp", 300.0, 1.0);

        private static final TemperatureUnit[] TYPES;
        private final ILangEntry langEntry;
        private final ILangEntry shortName;
        private final String symbol;
        private final String tabName;
        public final double zeroOffset;
        public final double intervalSize;

        private TemperatureUnit(ILangEntry langEntry, ILangEntry shortName, String symbol, String tabName, double offset, double size) {
            this.langEntry = langEntry;
            this.shortName = shortName;
            this.symbol = symbol;
            this.tabName = tabName;
            this.zeroOffset = offset;
            this.intervalSize = size;
        }

        public double convertFromK(double temp, boolean shift) {
            return temp * this.intervalSize - (shift ? this.zeroOffset : 0.0);
        }

        public double convertToK(double temp, boolean shift) {
            return (temp + (shift ? this.zeroOffset : 0.0)) / this.intervalSize;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public ILangEntry getLabel() {
            return this.langEntry;
        }

        @Override
        public String getTranslationKey() {
            return this.shortName.getTranslationKey();
        }

        public String getTabName() {
            return this.tabName;
        }

        @Override
        @Nonnull
        public TemperatureUnit byIndex(int index) {
            return MathUtils.getByIndexMod(TYPES, index);
        }

        static {
            TYPES = TemperatureUnit.values();
        }
    }

    private static interface Unit {
        public String getSymbol();

        public ILangEntry getLabel();
    }

    public static enum MeasurementUnit {
        FEMTO("Femto", "f", 1.0E-15),
        PICO("Pico", "p", 1.0E-12),
        NANO("Nano", "n", 1.0E-9),
        MICRO("Micro", "\u00b5", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        BASE("", "", 1.0),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0),
        GIGA("Giga", "G", 1.0E9),
        TERA("Tera", "T", 1.0E12),
        PETA("Peta", "P", 1.0E15),
        EXA("Exa", "E", 1.0E18),
        ZETTA("Zetta", "Z", 1.0E21),
        YOTTA("Yotta", "Y", 1.0E24);

        private final String name;
        private final String symbol;
        private final double value;

        private MeasurementUnit(String name, String symbol, double value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double d) {
            return d / this.value;
        }

        public boolean above(double d) {
            return d > this.value;
        }

        public boolean below(double d) {
            return d < this.value;
        }
    }

    public static enum RadiationUnit implements Unit
    {
        SV("Sv"),
        SVH("Sv/h");

        private final String symbol;

        private RadiationUnit(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public ILangEntry getLabel() {
            return MekanismLang.ERROR;
        }
    }

    public record EnergyConversionRate(CachedFloatingLongValue from, CachedFloatingLongValue to) {
    }
}

