/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2DoubleArrayMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Upgrade;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.OwnerDisplay;
import mekanism.common.util.text.UpgradeDisplay;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class MekanismUtils {
    public static final Codec<Direction> DIRECTION_CODEC = StringRepresentable.m_14350_(Direction::values, Direction::m_122402_);
    public static final float ONE_OVER_ROOT_TWO = (float)(1.0 / Math.sqrt(2.0));
    private static final List<UUID> warnedFails = new ArrayList<UUID>();

    public static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            Mekanism.logger.error("Stack size changed by a different amount ({}) than requested ({}).", (Object)actual, (Object)expected, (Object)new Exception());
        }
    }

    public static void logExpectedZero(FloatingLong actual) {
        if (!actual.isZero()) {
            Mekanism.logger.error("Energy value changed by a different amount ({}) than requested (zero).", (Object)actual, (Object)new Exception());
        }
    }

    public static Component logFormat(Object message) {
        return MekanismUtils.logFormat(EnumColor.GRAY, message);
    }

    public static Component logFormat(EnumColor messageColor, Object message) {
        return MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, messageColor, message);
    }

    @Nullable
    public static Player tryGetClientPlayer() {
        return (Player)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> MekanismClient::tryGetClientPlayer);
    }

    @Nonnull
    public static String getModId(@Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        String modid = item.getCreatorModId(stack);
        if (modid == null) {
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null) {
                Mekanism.logger.error("Unexpected null registry name for item of class type: {}", (Object)item.getClass().getSimpleName());
                return "";
            }
            return registryName.m_135827_();
        }
        return modid;
    }

    public static ItemStack getItemInHand(LivingEntity entity, HumanoidArm side) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return MekanismUtils.getItemInHand(player, side);
        }
        if (side == HumanoidArm.RIGHT) {
            return entity.m_21205_();
        }
        return entity.m_21206_();
    }

    public static ItemStack getItemInHand(Player player, HumanoidArm side) {
        if (player.m_5737_() == side) {
            return player.m_21205_();
        }
        return player.m_21206_();
    }

    public static Direction getLeft(Direction orientation) {
        return orientation.m_122427_();
    }

    public static Direction getRight(Direction orientation) {
        return orientation.m_122428_();
    }

    public static double fractionUpgrades(IUpgradeTile tile, Upgrade type) {
        if (tile.supportsUpgrade(type)) {
            return (double)tile.getComponent().getUpgrades(type) / (double)type.getMax();
        }
        return 0.0;
    }

    public static float getScale(float prevScale, IExtendedFluidTank tank) {
        return MekanismUtils.getScale(prevScale, tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, IChemicalTank<?, ?> tank) {
        return MekanismUtils.getScale(prevScale, tank.getStored(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, int stored, int capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0 ? 0.0f : (float)stored / (float)capacity, empty, stored == capacity);
    }

    public static float getScale(float prevScale, long stored, long capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0L ? 0.0f : (float)((double)stored / (double)capacity), empty, stored == capacity);
    }

    public static float getScale(float prevScale, IEnergyContainer container) {
        FloatingLong stored = container.getEnergy();
        FloatingLong capacity = container.getMaxEnergy();
        float targetScale = capacity.isZero() ? 0.0f : stored.divide(capacity).floatValue();
        return MekanismUtils.getScale(prevScale, targetScale, container.isEmpty(), stored.equals(capacity));
    }

    public static float getScale(float prevScale, float targetScale, boolean empty, boolean full) {
        float difference = Math.abs(prevScale - targetScale);
        if ((double)difference > 0.01) {
            return (9.0f * prevScale + targetScale) / 10.0f;
        }
        if (!empty && full && difference > 0.0f) {
            return targetScale;
        }
        if (!empty && prevScale == 0.0f) {
            return targetScale;
        }
        if (empty && (double)prevScale < 0.01) {
            return 0.0f;
        }
        return prevScale;
    }

    public static long getBaseUsage(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades() && tile.supportsUpgrade(Upgrade.GAS)) {
            return Math.round((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.GAS)));
        }
        return def;
    }

    public static int getTicks(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToInt((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), -MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED)));
        }
        return def;
    }

    public static FloatingLong getEnergyPerTick(IUpgradeTile tile, FloatingLong def) {
        if (tile.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static double getGasPerTickMeanMultiplier(IUpgradeTile tile) {
        if (tile.supportsUpgrades()) {
            if (tile.supportsUpgrade(Upgrade.GAS)) {
                return Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.GAS));
            }
            return Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED));
        }
        return 1.0;
    }

    public static FloatingLong getMaxEnergy(IUpgradeTile tile, FloatingLong def) {
        if (tile.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static FloatingLong getMaxEnergy(ItemStack stack, FloatingLong def) {
        float numUpgrades = 0.0f;
        if (ItemDataUtils.hasData(stack, "componentUpgrade", 10)) {
            Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getCompound(stack, "componentUpgrade"));
            numUpgrades = upgrades.getOrDefault(Upgrade.ENERGY, 0).intValue();
        }
        return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), numUpgrades / (float)Upgrade.ENERGY.getMax()));
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return Mekanism.rl(type.getPrefix() + name);
    }

    public static boolean canFunction(TileEntityMekanism tile) {
        if (!tile.supportsRedstone()) {
            return true;
        }
        return switch (tile.getControlType()) {
            default -> throw new IncompatibleClassChangeError();
            case IRedstoneControl.RedstoneControl.DISABLED -> true;
            case IRedstoneControl.RedstoneControl.HIGH -> tile.isPowered();
            case IRedstoneControl.RedstoneControl.LOW -> {
                if (!tile.isPowered()) {
                    yield true;
                }
                yield false;
            }
            case IRedstoneControl.RedstoneControl.PULSE -> tile.isPowered() && !tile.wasPowered();
        };
    }

    public static BlockHitResult rayTrace(Player player) {
        return MekanismUtils.rayTrace(player, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult rayTrace(Player player, ClipContext.Fluid fluidMode) {
        return MekanismUtils.rayTrace(player, player.m_21133_((net.minecraft.world.entity.ai.attributes.Attribute)ForgeMod.REACH_DISTANCE.get()), fluidMode);
    }

    public static BlockHitResult rayTrace(Player player, double reach) {
        return MekanismUtils.rayTrace(player, reach, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult rayTrace(Player player, double reach, ClipContext.Fluid fluidMode) {
        Vec3 headVec = MekanismUtils.getHeadVec(player);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endVec = headVec.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
        return player.m_20193_().m_45547_(new ClipContext(headVec, endVec, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    private static Vec3 getHeadVec(Player player) {
        double posY = player.m_20186_() + (double)player.m_20192_();
        if (player.m_6047_()) {
            posY -= 0.08;
        }
        return new Vec3(player.m_20185_(), posY, player.m_20189_());
    }

    public static void addFrequencyToTileTooltip(ItemStack stack, FrequencyType<?> frequencyType, List<Component> tooltip) {
        ItemDataUtils.setCompoundIfPresent(stack, "componentFrequency", frequencyComponent -> NBTUtils.setCompoundIfPresent(frequencyComponent, frequencyType.getName(), frequencyCompound -> {
            String owner;
            Object frequency = frequencyType.create((CompoundTag)frequencyCompound);
            ((Frequency)frequency).setValid(false);
            tooltip.add((Component)MekanismLang.FREQUENCY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, ((Frequency)frequency).getName()));
            if (((Frequency)frequency).getOwner() != null && (owner = OwnerDisplay.getOwnerName(MekanismUtils.tryGetClientPlayer(), ((Frequency)frequency).getOwner(), ((Frequency)frequency).getClientOwner())) != null) {
                tooltip.add((Component)MekanismLang.OWNER.translateColored(EnumColor.INDIGO, EnumColor.GRAY, owner));
            }
            tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, ((Frequency)frequency).isPublic() ? APILang.PUBLIC : APILang.PRIVATE));
        }));
    }

    public static void addFrequencyItemTooltip(ItemStack stack, List<Component> tooltip) {
        Frequency.FrequencyIdentity frequency = ((IFrequencyItem)stack.m_41720_()).getFrequencyIdentity(stack);
        if (frequency != null) {
            String owner;
            tooltip.add((Component)MekanismLang.FREQUENCY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, frequency.key()));
            CompoundTag frequencyCompound = ItemDataUtils.getCompound(stack, "frequency");
            if (frequencyCompound.m_128403_("owner") && (owner = OwnerDisplay.getOwnerName(MekanismUtils.tryGetClientPlayer(), frequencyCompound.m_128342_("owner"), null)) != null) {
                tooltip.add((Component)MekanismLang.OWNER.translateColored(EnumColor.INDIGO, EnumColor.GRAY, owner));
            }
            tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, frequency.isPublic() ? APILang.PUBLIC : APILang.PRIVATE));
        }
    }

    public static void addUpgradesToTooltip(ItemStack stack, List<Component> tooltip) {
        ItemDataUtils.setCompoundIfPresent(stack, "componentUpgrade", upgradeComponent -> Upgrade.buildMap(upgradeComponent).forEach((upgrade, level) -> tooltip.add(UpgradeDisplay.of(upgrade, level).getTextComponent())));
    }

    public static Component getEnergyDisplayShort(FloatingLong energy) {
        UnitDisplayUtils.EnergyUnit configured = UnitDisplayUtils.EnergyUnit.getConfigured();
        return UnitDisplayUtils.getDisplayShort(configured.convertToAsFloatingLong(energy), configured);
    }

    public static FloatingLong convertToJoules(FloatingLong energy) {
        return UnitDisplayUtils.EnergyUnit.getConfigured().convertFrom(energy);
    }

    public static FloatingLong convertToDisplay(FloatingLong energy) {
        return UnitDisplayUtils.EnergyUnit.getConfigured().convertToAsFloatingLong(energy);
    }

    public static Component getTemperatureDisplay(double temp, UnitDisplayUtils.TemperatureUnit unit, boolean shift) {
        double tempKelvin = unit.convertToK(temp, true);
        return UnitDisplayUtils.getDisplayShort(tempKelvin, (UnitDisplayUtils.TemperatureUnit)MekanismConfig.common.tempUnit.get(), shift);
    }

    public static CraftingContainer getDummyCraftingInv() {
        AbstractContainerMenu tempContainer = new AbstractContainerMenu(MenuType.f_39968_, 1){

            public boolean m_6875_(@Nonnull Player player) {
                return false;
            }
        };
        return new CraftingContainer(tempContainer, 3, 3);
    }

    public static boolean canUseAsWrench(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof ItemConfigurator) {
            ItemConfigurator configurator = (ItemConfigurator)item;
            return configurator.getMode(stack) == ItemConfigurator.ConfiguratorMode.WRENCH;
        }
        return stack.m_204117_(MekanismTags.Items.CONFIGURATORS);
    }

    @Nonnull
    public static String getLastKnownUsername(@Nullable UUID uuid) {
        Optional gp;
        if (uuid == null) {
            return "<???>";
        }
        String ret = UsernameCache.getLastKnownUsername((UUID)uuid);
        if (ret == null && !warnedFails.contains(uuid) && EffectiveSide.get().isServer() && (gp = ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(uuid)).isPresent()) {
            ret = ((GameProfile)gp.get()).getName();
        }
        if (ret == null && !warnedFails.contains(uuid)) {
            Mekanism.logger.warn("Failed to retrieve username for UUID {}, you might want to add it to the JSON cache", (Object)uuid);
            warnedFails.add(uuid);
        }
        return ret == null ? "<" + uuid + ">" : ret;
    }

    public static void speedUpEffectSafely(LivingEntity entity, MobEffectInstance effectInstance) {
        int remainingDuration;
        if (effectInstance.m_19557_() > 0 && (remainingDuration = effectInstance.m_19579_()) == 0 && effectInstance.f_19510_ != null) {
            effectInstance.m_19548_(effectInstance.f_19510_);
            effectInstance.f_19510_ = effectInstance.f_19510_.f_19510_;
            MekanismUtils.onChangedPotionEffect(entity, effectInstance, true);
        }
    }

    private static void onChangedPotionEffect(LivingEntity entity, MobEffectInstance effectInstance, boolean reapply) {
        entity.f_20948_ = true;
        if (reapply && !entity.f_19853_.f_46443_) {
            MobEffect effect = effectInstance.m_19544_();
            effect.m_6386_(entity, entity.m_21204_(), effectInstance.m_19564_());
            effect.m_6385_(entity, entity.m_21204_(), effectInstance.m_19564_());
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(entity.m_142049_(), effectInstance));
            CriteriaTriggers.f_10550_.m_149262_(player, null);
        }
    }

    public static boolean isSameTypeFactory(Block block, BlockEntityType<?> factoryTileType) {
        AttributeFactoryType attribute = Attribute.get(block, AttributeFactoryType.class);
        if (attribute == null) {
            return false;
        }
        FactoryType factoryType = attribute.getFactoryType();
        for (FactoryTier factoryTier : EnumUtils.FACTORY_TIERS) {
            if (MekanismTileEntityTypes.getFactoryTile(factoryTier, factoryType).get() != factoryTileType) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static InteractionResult performActions(InteractionResult firstAction, Supplier<InteractionResult> ... secondaryActions) {
        if (firstAction.m_19077_()) {
            return firstAction;
        }
        InteractionResult result = firstAction;
        boolean hasFailed = result == InteractionResult.FAIL;
        for (Supplier<InteractionResult> secondaryAction : secondaryActions) {
            result = secondaryAction.get();
            if (result.m_19077_()) {
                return result;
            }
            hasFailed &= result == InteractionResult.FAIL;
        }
        if (hasFailed) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static int redstoneLevelFromContents(long amount, long capacity) {
        double fractionFull = capacity == 0L ? 0.0 : (double)amount / (double)capacity;
        return Mth.m_14143_((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public static int redstoneLevelFromContents(FloatingLong amount, FloatingLong capacity) {
        if (capacity.isZero() || amount.isZero()) {
            return 0;
        }
        return 1 + amount.divide(capacity).multiply(14L).intValue();
    }

    public static int redstoneLevelFromContents(List<IInventorySlot> slots) {
        long totalCount = 0L;
        long totalLimit = 0L;
        for (IInventorySlot slot : slots) {
            if (slot.isEmpty()) {
                totalLimit += (long)slot.getLimit(ItemStack.f_41583_);
                continue;
            }
            totalCount += (long)slot.getCount();
            totalLimit += (long)slot.getLimit(slot.getStack());
        }
        return MekanismUtils.redstoneLevelFromContents(totalCount, totalLimit);
    }

    public static boolean isPlayingMode(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    public static List<String> getParameterNames(@Nullable JsonObject classMethods, String method, String signature) {
        JsonElement params;
        JsonObject signatures;
        if (classMethods != null && (signatures = classMethods.getAsJsonObject(method)) != null && (params = signatures.get(signature)) != null) {
            if (params.isJsonArray()) {
                JsonArray paramArray = params.getAsJsonArray();
                ArrayList<String> paramNames = new ArrayList<String>(paramArray.size());
                for (JsonElement param : paramArray) {
                    paramNames.add(param.getAsString());
                }
                return Collections.unmodifiableList(paramNames);
            }
            return Collections.singletonList(params.getAsString());
        }
        return Collections.emptyList();
    }

    public static Map<Fluid, FluidInDetails> getFluidsIn(Player player, UnaryOperator<AABB> modifyBoundingBox) {
        int zMax;
        AABB bb = (AABB)modifyBoundingBox.apply(player.m_142469_().m_82406_(0.001));
        int xMin = Mth.m_14107_((double)bb.f_82288_);
        int xMax = Mth.m_14165_((double)bb.f_82291_);
        int yMin = Mth.m_14107_((double)bb.f_82289_);
        int yMax = Mth.m_14165_((double)bb.f_82292_);
        int zMin = Mth.m_14107_((double)bb.f_82290_);
        if (!player.f_19853_.m_46812_(xMin, yMin, zMin, xMax, yMax, zMax = Mth.m_14165_((double)bb.f_82293_))) {
            return Collections.emptyMap();
        }
        HashMap<Fluid, FluidInDetails> fluidsIn = new HashMap<Fluid, FluidInDetails>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    double fluidY;
                    mutablePos.m_122178_(x, y, z);
                    FluidState fluidState = player.f_19853_.m_6425_((BlockPos)mutablePos);
                    if (fluidState.m_76178_() || !(bb.f_82289_ <= (fluidY = (double)((float)y + fluidState.m_76155_((BlockGetter)player.f_19853_, (BlockPos)mutablePos))))) continue;
                    Fluid fluid = fluidState.m_76152_();
                    if (fluid instanceof FlowingFluid) {
                        FlowingFluid flowingFluid = (FlowingFluid)fluid;
                        fluid = flowingFluid.m_5613_();
                    }
                    FluidInDetails details = fluidsIn.computeIfAbsent(fluid, f -> new FluidInDetails());
                    details.positions.add(mutablePos.m_7949_());
                    double actualFluidHeight = fluidY > bb.f_82292_ ? bb.f_82292_ - Math.max(bb.f_82289_, (double)y) : fluidY - Math.max(bb.f_82289_, (double)y);
                    details.heights.merge(ChunkPos.m_45589_((int)x, (int)z), actualFluidHeight, Double::sum);
                }
            }
        }
        return fluidsIn;
    }

    public static void veinMineArea(IEnergyContainer energyContainer, FloatingLong energyRequired, Level world, BlockPos pos, ServerPlayer player, ItemStack stack, Item usedTool, Object2IntMap<BlockPos> found, BlastEnergyFunction blastEnergy, VeinEnergyFunction veinEnergy) {
        FloatingLong energyUsed = FloatingLong.ZERO;
        FloatingLong energyAvailable = energyContainer.getEnergy();
        energyAvailable = energyAvailable.subtract(energyRequired);
        for (Object2IntMap.Entry foundEntry : found.object2IntEntrySet()) {
            int exp;
            int distance;
            FloatingLong destroyEnergy;
            float hardness;
            BlockState targetState;
            BlockPos foundPos = (BlockPos)foundEntry.getKey();
            if (pos.equals((Object)foundPos) || (targetState = world.m_8055_(foundPos)).m_60795_() || (hardness = targetState.m_60800_((BlockGetter)world, foundPos)) == -1.0f || energyUsed.add(destroyEnergy = (distance = foundEntry.getIntValue()) == 0 ? blastEnergy.calc(hardness) : veinEnergy.calc(hardness, distance, targetState)).greaterThan(energyAvailable) || (exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)player.f_8941_.m_9290_(), (ServerPlayer)player, (BlockPos)foundPos)) == -1) continue;
            Block block = targetState.m_60734_();
            BlockEntity tileEntity = WorldUtils.getTileEntity((BlockGetter)world, foundPos);
            if (!targetState.onDestroyedByPlayer(world, foundPos, (Player)player, true, targetState.m_60819_())) continue;
            block.m_6786_((LevelAccessor)world, foundPos, targetState);
            block.m_6240_(world, (Player)player, foundPos, targetState, tileEntity, stack);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)usedTool));
            if (exp > 0) {
                block.m_49805_((ServerLevel)world, foundPos, exp);
            }
            energyUsed = energyUsed.plusEqual(destroyEnergy);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_BUTTON("gui/button"),
        GUI_BAR("gui/bar"),
        GUI_HUD("gui/hud"),
        GUI_GAUGE("gui/gauge"),
        GUI_PROGRESS("gui/progress"),
        GUI_SLOT("gui/slot"),
        GUI_TAB("gui/tabs"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/block"),
        TEXTURE_ITEMS("textures/item"),
        MODEL("models"),
        INFUSE("infuse"),
        PIGMENT("pigment"),
        SLURRY("slurry");

        private final String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }

    public static class FluidInDetails {
        private final List<BlockPos> positions = new ArrayList<BlockPos>();
        private final Long2DoubleMap heights = new Long2DoubleArrayMap();

        public List<BlockPos> getPositions() {
            return this.positions;
        }

        public double getMaxHeight() {
            return this.heights.values().doubleStream().max().orElse(0.0);
        }
    }

    @FunctionalInterface
    public static interface BlastEnergyFunction {
        public FloatingLong calc(float var1);
    }

    @FunctionalInterface
    public static interface VeinEnergyFunction {
        public FloatingLong calc(float var1, int var2, BlockState var3);
    }
}

