/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import net.minecraft.network.FriendlyByteBuf;

public abstract class SingleChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements ChemicalStackIngredient<CHEMICAL, STACK> {
    @Nonnull
    private final STACK chemicalInstance;

    public SingleChemicalStackIngredient(@Nonnull STACK chemicalInstance) {
        this.chemicalInstance = chemicalInstance;
    }

    protected abstract ChemicalIngredientInfo<CHEMICAL, STACK> getIngredientInfo();

    @Override
    public boolean test(@Nonnull STACK chemicalStack) {
        return this.testType((CHEMICAL)chemicalStack) && ((ChemicalStack)chemicalStack).getAmount() >= ((ChemicalStack)this.chemicalInstance).getAmount();
    }

    @Override
    public boolean testType(@Nonnull STACK chemicalStack) {
        return ((ChemicalStack)this.chemicalInstance).isTypeEqual((ChemicalStack)((ChemicalStack)Objects.requireNonNull(chemicalStack)));
    }

    @Override
    public boolean testType(@Nonnull CHEMICAL chemical) {
        return ((ChemicalStack)this.chemicalInstance).isTypeEqual((Chemical)((Chemical)Objects.requireNonNull(chemical)));
    }

    @Override
    @Nonnull
    public STACK getMatchingInstance(@Nonnull STACK chemicalStack) {
        if (this.test(chemicalStack)) {
            return this.getIngredientInfo().createStack(this.chemicalInstance, ((ChemicalStack)this.chemicalInstance).getAmount());
        }
        return this.getIngredientInfo().getEmptyStack();
    }

    @Override
    public long getNeededAmount(@Nonnull STACK stack) {
        return this.testType((CHEMICAL)stack) ? ((ChemicalStack)this.chemicalInstance).getAmount() : 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return false;
    }

    @Override
    @Nonnull
    public List<@NonNull STACK> getRepresentations() {
        return Collections.singletonList(this.chemicalInstance);
    }

    public CHEMICAL getInputRaw() {
        return ((ChemicalStack)this.chemicalInstance).getType();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)ChemicalIngredientDeserializer.IngredientType.SINGLE);
        ((ChemicalStack)this.chemicalInstance).writeToPacket(buffer);
    }

    @Override
    @Nonnull
    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("amount", (Number)((ChemicalStack)this.chemicalInstance).getAmount());
        json.addProperty(this.getIngredientInfo().getSerializationKey(), ((ChemicalStack)this.chemicalInstance).getTypeRegistryName().toString());
        return json;
    }
}

