/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.common.tile.component.TileComponentSecurity;

public interface ISecurityTile
extends ISecurityObject {
    public TileComponentSecurity getSecurity();

    default public boolean hasSecurity() {
        return true;
    }

    @Override
    @Nullable
    default public UUID getOwnerUUID() {
        TileComponentSecurity security = this.getSecurity();
        return security == null ? null : security.getOwnerUUID();
    }

    @Override
    @Nullable
    default public String getOwnerName() {
        TileComponentSecurity security = this.getSecurity();
        return security == null ? null : security.getOwnerName();
    }

    @Override
    @Nonnull
    default public SecurityMode getSecurityMode() {
        TileComponentSecurity security = this.getSecurity();
        return security == null ? SecurityMode.PUBLIC : security.getMode();
    }

    @Override
    default public void setSecurityMode(@Nonnull SecurityMode mode) {
        TileComponentSecurity security = this.getSecurity();
        if (security != null) {
            security.setMode(mode);
        }
    }

    @Override
    default public void setOwnerUUID(@Nullable UUID owner) {
        TileComponentSecurity security = this.getSecurity();
        if (security != null) {
            security.setOwnerUUID(owner);
        }
    }
}

