/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IGasProvider;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.tags.ITag;

public final class NSSGas
extends AbstractNSSTag<Gas> {
    private NSSGas(@Nonnull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @Nonnull
    public static NSSGas createGas(@Nonnull GasStack stack) {
        return NSSGas.createGas((Gas)stack.getType());
    }

    @Nonnull
    public static NSSGas createGas(@Nonnull IGasProvider gasProvider) {
        return NSSGas.createGas((Gas)gasProvider.getChemical());
    }

    @Nonnull
    public static NSSGas createGas(@Nonnull Gas gas) {
        if (gas.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSGas with an empty gas");
        }
        return NSSGas.createGas(gas.getRegistryName());
    }

    @Nonnull
    public static NSSGas createGas(@Nonnull ResourceLocation gasID) {
        return new NSSGas(gasID, false);
    }

    @Nonnull
    public static NSSGas createTag(@Nonnull ResourceLocation tagId) {
        return new NSSGas(tagId, true);
    }

    @Nonnull
    public static NSSGas createTag(@Nonnull TagKey<Gas> tag) {
        return NSSGas.createTag(tag.f_203868_());
    }

    protected boolean isInstance(AbstractNSSTag o) {
        return o instanceof NSSGas;
    }

    @Nonnull
    public String getJsonPrefix() {
        return "GAS|";
    }

    @Nonnull
    public String getType() {
        return "Gas";
    }

    @Nonnull
    protected Optional<Either<HolderSet.Named<Gas>, ITag<Gas>>> getTag() {
        return this.getTag(MekanismAPI.gasRegistry());
    }

    protected Function<Gas, NormalizedSimpleStack> createNew() {
        return NSSGas::createGas;
    }
}

