/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.forgeenergy;

import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyIntegration
implements IEnergyStorage {
    private final IStrictEnergyHandler handler;

    public ForgeEnergyIntegration(IStrictEnergyHandler handler) {
        this.handler = handler;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive <= 0) {
            return 0;
        }
        FloatingLong toInsert = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(maxReceive);
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsInt(toInsert.subtract(this.handler.insertEnergy(toInsert, Action.get(!simulate))));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return maxExtract <= 0 ? 0 : UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsInt(this.handler.extractEnergy(UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(maxExtract), Action.get(!simulate)));
    }

    public int getEnergyStored() {
        int containers = this.handler.getEnergyContainerCount();
        if (containers > 0) {
            int energy = 0;
            for (int container = 0; container < containers; ++container) {
                int total = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsInt(this.handler.getEnergy(container));
                if (total > Integer.MAX_VALUE - energy) {
                    energy = Integer.MAX_VALUE;
                    break;
                }
                energy += total;
            }
            return energy;
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        int containers = this.handler.getEnergyContainerCount();
        if (containers > 0) {
            int maxEnergy = 0;
            for (int container = 0; container < containers; ++container) {
                int max = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsInt(this.handler.getMaxEnergy(container));
                if (max > Integer.MAX_VALUE - maxEnergy) {
                    maxEnergy = Integer.MAX_VALUE;
                    break;
                }
                maxEnergy += max;
            }
            return maxEnergy;
        }
        return 0;
    }

    public boolean canExtract() {
        if (!this.handler.extractEnergy(FloatingLong.ONE, Action.SIMULATE).isZero()) {
            return true;
        }
        for (int container = 0; container < this.handler.getEnergyContainerCount(); ++container) {
            if (this.handler.getEnergy(container).isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean canReceive() {
        if (this.handler.insertEnergy(FloatingLong.ONE, Action.SIMULATE).smallerThan(FloatingLong.ONE)) {
            return true;
        }
        for (int container = 0; container < this.handler.getEnergyContainerCount(); ++container) {
            if (this.handler.getNeededEnergy(container).isZero()) continue;
            return false;
        }
        return true;
    }
}

