/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.energy.IEnergyCompat;
import mekanism.common.integration.energy.StrictEnergyCompat;
import mekanism.common.integration.energy.forgeenergy.ForgeEnergyCompat;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyCompatUtils {
    private static final List<IEnergyCompat> energyCompats = List.of(new StrictEnergyCompat(), new ForgeEnergyCompat());

    private EnergyCompatUtils() {
    }

    public static List<IEnergyCompat> getCompats() {
        return energyCompats;
    }

    public static boolean isEnergyCapability(@Nonnull Capability<?> capability) {
        if (capability.isRegistered()) {
            for (IEnergyCompat energyCompat : energyCompats) {
                if (!energyCompat.isMatchingCapability(capability)) continue;
                return energyCompat.isUsable();
            }
        }
        return false;
    }

    public static List<Capability<?>> getEnabledEnergyCapabilities() {
        return energyCompats.stream().filter(IEnergyCompat::isUsable).map(IEnergyCompat::getCapability).collect(Collectors.toList());
    }

    private static boolean isTileValid(@Nullable BlockEntity tile) {
        return tile != null && !tile.m_58901_() && tile.m_58898_();
    }

    public static boolean hasStrictEnergyHandler(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && EnergyCompatUtils.hasStrictEnergyHandler((ICapabilityProvider)stack, null);
    }

    public static boolean hasStrictEnergyHandler(@Nullable BlockEntity tile, Direction side) {
        return EnergyCompatUtils.isTileValid(tile) && EnergyCompatUtils.hasStrictEnergyHandler((ICapabilityProvider)tile, side);
    }

    private static boolean hasStrictEnergyHandler(ICapabilityProvider provider, Direction side) {
        for (IEnergyCompat energyCompat : energyCompats) {
            if (!energyCompat.isUsable() || !energyCompat.isCapabilityPresent(provider, side)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static IStrictEnergyHandler getStrictEnergyHandler(@Nonnull ItemStack stack) {
        return EnergyCompatUtils.getLazyStrictEnergyHandler(stack).resolve().orElse(null);
    }

    @Nonnull
    public static LazyOptional<IStrictEnergyHandler> getLazyStrictEnergyHandler(@Nonnull ItemStack stack) {
        return stack.m_41619_() ? LazyOptional.empty() : EnergyCompatUtils.getLazyStrictEnergyHandler((ICapabilityProvider)stack, null);
    }

    @Nonnull
    public static LazyOptional<IStrictEnergyHandler> getLazyStrictEnergyHandler(@Nullable BlockEntity tile, Direction side) {
        return EnergyCompatUtils.isTileValid(tile) ? EnergyCompatUtils.getLazyStrictEnergyHandler((ICapabilityProvider)tile, side) : LazyOptional.empty();
    }

    @Nonnull
    private static LazyOptional<IStrictEnergyHandler> getLazyStrictEnergyHandler(ICapabilityProvider provider, Direction side) {
        for (IEnergyCompat energyCompat : energyCompats) {
            LazyOptional<IStrictEnergyHandler> handler;
            if (!energyCompat.isUsable() || !(handler = energyCompat.getLazyStrictEnergyHandler(provider, side)).isPresent()) continue;
            return handler;
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public static <T> LazyOptional<T> getEnergyCapability(@Nonnull Capability<T> capability, @Nonnull IStrictEnergyHandler handler) {
        if (capability.isRegistered()) {
            for (IEnergyCompat energyCompat : energyCompats) {
                if (!energyCompat.isUsable() || !energyCompat.isMatchingCapability(capability)) continue;
                return energyCompat.getHandlerAs(handler).cast();
            }
        }
        return LazyOptional.empty();
    }

    public static boolean useIC2() {
        return Mekanism.hooks.IC2Loaded && !MekanismConfig.general.blacklistIC2.get();
    }
}

