/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.text.ILangEntry;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class ModuleConfigItem<TYPE>
implements IModuleConfigItem<TYPE> {
    private final Module<?> module;
    private final String name;
    private final ILangEntry description;
    private final ModuleConfigData<TYPE> data;

    public ModuleConfigItem(Module<?> module, String name, ILangEntry description, ModuleConfigData<TYPE> data) {
        this.module = module;
        this.name = name;
        this.description = description;
        this.data = data;
    }

    public Component getDescription() {
        return this.description.translate(new Object[0]);
    }

    public ModuleConfigData<TYPE> getData() {
        return this.data;
    }

    @Override
    @Nonnull
    public TYPE get() {
        return this.data.get();
    }

    @Override
    public void set(@Nonnull TYPE val) {
        this.set(val, null);
    }

    public void set(@Nonnull TYPE val, @Nullable Runnable callback) {
        Objects.requireNonNull(val, "Value cannot be null.");
        this.data.set(val);
        for (Module<?> m : ModuleHelper.INSTANCE.loadAll(this.module.getContainer())) {
            boolean checkModeState;
            if (this.name.equals("enabled") && val == Boolean.TRUE) {
                if (m.getData() != this.module.getData() && m.getData().isExclusive(this.module.getData().getExclusiveFlags())) {
                    m.setDisabledForce(callback != null);
                }
                checkModeState = true;
            } else {
                boolean bl = checkModeState = this.name.equals("handleModeChange") && val == Boolean.TRUE;
            }
            if (!checkModeState || !this.module.handlesModeChange() || !m.handlesModeChange() || m.getData() == this.module.getData()) continue;
            m.setModeHandlingDisabledForce();
        }
        this.module.save(callback);
    }

    public void read(CompoundTag tag) {
        if (tag.m_128441_(this.name)) {
            this.data.read(this.name, tag);
        }
    }

    public void write(CompoundTag tag) {
        this.data.write(this.name, tag);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public static class DisableableModuleConfigItem
    extends ModuleConfigItem<Boolean> {
        private final BooleanSupplier isConfigEnabled;

        public DisableableModuleConfigItem(Module<?> module, String name, ILangEntry description, boolean def, BooleanSupplier isConfigEnabled) {
            super(module, name, description, new ModuleBooleanData(def));
            this.isConfigEnabled = isConfigEnabled;
        }

        @Override
        @Nonnull
        public Boolean get() {
            return this.isConfigEnabled() && (Boolean)super.get() != false;
        }

        public boolean isConfigEnabled() {
            return this.isConfigEnabled.getAsBoolean();
        }
    }
}

