/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class RenderMechanicalPipe
extends RenderTransmitterBase<TileEntityMechanicalPipe> {
    private static final int stages = 100;
    private static final float height = 0.45f;
    private static final float offset = 0.015f;
    private static final Int2ObjectMap<FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>>> cachedLiquids = new Int2ObjectArrayMap(7);

    public RenderMechanicalPipe(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void onStitch() {
        cachedLiquids.clear();
    }

    @Override
    protected void render(TileEntityMechanicalPipe tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        MechanicalPipe pipe = tile.getTransmitter();
        if (pipe.hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)pipe.getTransmitterNetwork();
            if (!network.lastFluid.isEmpty() && !network.fluidTank.isEmpty() && network.currentScale > 0.0f) {
                FluidStack fluidStack = network.lastFluid;
                float fluidScale = network.currentScale;
                int stage = fluidStack.getFluid().getAttributes().isGaseous(fluidStack) ? 99 : Math.max(3, (int)(fluidScale * 99.0f));
                int glow = MekanismRenderer.calculateGlowLight(light, fluidStack);
                int color = MekanismRenderer.getColorARGB(fluidStack, fluidScale);
                ArrayList<String> connectionContents = new ArrayList<String>();
                MekanismRenderer.Model3D model = this.getModel(null, fluidStack, stage);
                VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
                for (Direction side : EnumUtils.DIRECTIONS) {
                    ConnectionType connectionType = pipe.getConnectionType(side);
                    if (connectionType == ConnectionType.NORMAL) {
                        MekanismRenderer.renderObject(this.getModel(side, fluidStack, stage), matrix, buffer, color, glow, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
                    } else if (connectionType != ConnectionType.NONE) {
                        connectionContents.add(side.m_7912_() + connectionType.m_7912_().toUpperCase(Locale.ROOT));
                    }
                    if (model == null) continue;
                    model.setSideRender(side, connectionType == ConnectionType.NONE || side.m_122434_().m_122478_() && stage != 99);
                }
                MekanismRenderer.renderObject(model, matrix, buffer, MekanismRenderer.getColorARGB(fluidStack, fluidScale), glow, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
                if (!connectionContents.isEmpty()) {
                    matrix.m_85836_();
                    matrix.m_85837_(0.5, 0.5, 0.5);
                    this.renderModel(tile, matrix, buffer, MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), MekanismRenderer.getAlpha(color), glow, overlayLight, MekanismRenderer.getFluidTexture(fluidStack, MekanismRenderer.FluidType.STILL), connectionContents);
                    matrix.m_85849_();
                }
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "mechanicalPipe";
    }

    @Nullable
    private MekanismRenderer.Model3D getModel(@Nullable Direction side, FluidStack fluid, int stage) {
        FluidRenderMap cachedFluids;
        int sideOrdinal;
        if (fluid.isEmpty()) {
            return null;
        }
        int n = sideOrdinal = side == null ? 6 : side.ordinal();
        if (cachedLiquids.containsKey(sideOrdinal)) {
            cachedFluids = (FluidRenderMap)((Object)cachedLiquids.get(sideOrdinal));
            if (cachedFluids.containsKey(fluid) && ((Int2ObjectMap)cachedFluids.get(fluid)).containsKey(stage)) {
                return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedFluids.get(fluid)).get(stage);
            }
        } else {
            cachedFluids = new FluidRenderMap();
            cachedLiquids.put(sideOrdinal, cachedFluids);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (side != null) {
            model.setSideRender(side, false);
            model.setSideRender(side.m_122424_(), false);
        }
        float stageRatio = (float)stage / 100.0f * 0.45f;
        switch (sideOrdinal) {
            case 0: {
                model.minX = 0.5f - stageRatio / 2.0f;
                model.minY = 0.0f;
                model.minZ = 0.5f - stageRatio / 2.0f;
                model.maxX = 0.5f + stageRatio / 2.0f;
                model.maxY = 0.265f;
                model.maxZ = 0.5f + stageRatio / 2.0f;
                break;
            }
            case 1: {
                model.minX = 0.5f - stageRatio / 2.0f;
                model.minY = 0.235f + stageRatio;
                model.minZ = 0.5f - stageRatio / 2.0f;
                model.maxX = 0.5f + stageRatio / 2.0f;
                model.maxY = 1.0f;
                model.maxZ = 0.5f + stageRatio / 2.0f;
                break;
            }
            case 2: {
                model.minX = 0.265f;
                model.minY = 0.265f;
                model.minZ = 0.0f;
                model.maxX = 0.735f;
                model.maxY = 0.265f + stageRatio;
                model.maxZ = 0.265f;
                break;
            }
            case 3: {
                model.minX = 0.265f;
                model.minY = 0.265f;
                model.minZ = 0.735f;
                model.maxX = 0.735f;
                model.maxY = 0.265f + stageRatio;
                model.maxZ = 1.0f;
                break;
            }
            case 4: {
                model.minX = 0.0f;
                model.minY = 0.265f;
                model.minZ = 0.265f;
                model.maxX = 0.265f;
                model.maxY = 0.265f + stageRatio;
                model.maxZ = 0.735f;
                break;
            }
            case 5: {
                model.minX = 0.735f;
                model.minY = 0.265f;
                model.minZ = 0.265f;
                model.maxX = 1.0f;
                model.maxY = 0.265f + stageRatio;
                model.maxZ = 0.735f;
                break;
            }
            case 6: {
                model.minX = 0.265f;
                model.minY = 0.265f;
                model.minZ = 0.265f;
                model.maxX = 0.735f;
                model.maxY = 0.265f + stageRatio;
                model.maxZ = 0.735f;
            }
        }
        ((Int2ObjectMap)cachedFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).putIfAbsent(stage, (Object)model);
        return model;
    }
}

