/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.lib.effect.BillboardingEffectRenderer;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.lib.effect.CustomEffect;
import mekanism.common.lib.math.Plane;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.particle.SPSOrbitEffect;
import mekanism.common.tile.multiblock.TileEntitySPSCasing;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class RenderSPS
extends MekanismTileEntityRenderer<TileEntitySPSCasing> {
    private static final CustomEffect CORE = new CustomEffect(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_effect.png"));
    private static final Map<UUID, BoltRenderer> boltRendererMap = new HashMap<UUID, BoltRenderer>();
    private static final float MIN_SCALE = 0.1f;
    private static final float MAX_SCALE = 4.0f;
    private static final Random rand = new Random();
    private final Minecraft minecraft = Minecraft.m_91087_();

    public static void clearBoltRenderers() {
        boltRendererMap.clear();
    }

    public RenderSPS(BlockEntityRendererProvider.Context context) {
        super(context);
        CORE.setColor(Color.rgbai(255, 255, 255, 240));
    }

    @Override
    protected void render(TileEntitySPSCasing tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        SPSMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (SPSMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && multiblock.getBounds() != null) {
            BoltRenderer bolts = boltRendererMap.computeIfAbsent(multiblock.inventoryID, mb -> new BoltRenderer());
            Vec3 center = Vec3.m_82528_((Vec3i)multiblock.getMinPos()).m_82549_(Vec3.m_82528_((Vec3i)multiblock.getMaxPos())).m_82549_(new Vec3(1.0, 1.0, 1.0)).m_82490_(0.5);
            Vec3 renderCenter = center.m_82492_((double)tile.m_58899_().m_123341_(), (double)tile.m_58899_().m_123342_(), (double)tile.m_58899_().m_123343_());
            if (!this.minecraft.m_91104_()) {
                for (SPSMultiblockData.CoilData data : multiblock.coilData.coilMap.values()) {
                    if (data.prevLevel <= 0) continue;
                    bolts.update(data.coilPos.hashCode(), RenderSPS.getBoltFromData(data, tile.m_58899_(), multiblock, renderCenter), partialTick);
                }
            }
            float energyScale = RenderSPS.getEnergyScale(multiblock.lastProcessed);
            int targetEffectCount = 0;
            if (!this.minecraft.m_91104_() && !multiblock.lastReceivedEnergy.isZero()) {
                if (rand.nextDouble() < (double)RenderSPS.getBoundedScale(energyScale, 0.01f, 0.4f)) {
                    VoxelCuboid.CuboidSide side = VoxelCuboid.CuboidSide.SIDES[rand.nextInt(6)];
                    Plane plane = Plane.getInnerCuboidPlane(multiblock.getBounds(), side);
                    Vec3 endPos = plane.getRandomPoint(rand).m_82492_((double)tile.m_58899_().m_123341_(), (double)tile.m_58899_().m_123342_(), (double)tile.m_58899_().m_123343_());
                    BoltEffect bolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, renderCenter, endPos, 15).size(0.01f * RenderSPS.getBoundedScale(energyScale, 0.5f, 5.0f)).lifespan(8).spawn(BoltEffect.SpawnFunction.NO_DELAY);
                    bolts.update(Objects.hash(new Object[]{side, endPos}), bolt, partialTick);
                }
                targetEffectCount = (int)RenderSPS.getBoundedScale(energyScale, 10.0f, 120.0f);
            }
            if (tile.orbitEffects.size() > targetEffectCount) {
                tile.orbitEffects.poll();
            } else if (tile.orbitEffects.size() < targetEffectCount && rand.nextDouble() < 0.5) {
                tile.orbitEffects.add(new SPSOrbitEffect(multiblock, center));
            }
            bolts.render(partialTick, matrix, renderer);
            if (multiblock.lastProcessed > 0.0) {
                CORE.setPos(center);
                CORE.setScale(RenderSPS.getBoundedScale(energyScale, 0.1f, 4.0f));
                BillboardingEffectRenderer.render(CORE, tile.m_58899_(), matrix, renderer, tile.m_58904_().m_46467_(), partialTick);
            }
            tile.orbitEffects.forEach(effect -> BillboardingEffectRenderer.render(effect, tile.m_58899_(), matrix, renderer, tile.m_58904_().m_46467_(), partialTick));
        }
    }

    private static float getEnergyScale(double lastProcessed) {
        return (float)Math.min(1.0, Math.max(0.0, (Math.log10(lastProcessed) + 2.0) / 4.0));
    }

    private static float getBoundedScale(float scale, float min, float max) {
        return min + scale * (max - min);
    }

    private static BoltEffect getBoltFromData(SPSMultiblockData.CoilData data, BlockPos pos, SPSMultiblockData multiblock, Vec3 center) {
        Vec3 start = Vec3.m_82512_((Vec3i)data.coilPos.m_142300_(data.side));
        start = start.m_82549_(Vec3.m_82528_((Vec3i)data.side.m_122436_()).m_82490_(0.5));
        int count = 1 + (data.prevLevel - 1) / 2;
        float size = 0.01f * (float)data.prevLevel;
        return new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), center, 15).count(count).size(size).lifespan(8).spawn(BoltEffect.SpawnFunction.delay(4.0f));
    }

    @Override
    protected String getProfilerSection() {
        return "supercriticalPhaseShifter";
    }

    public boolean shouldRenderOffScreen(TileEntitySPSCasing tile) {
        if (tile.isMaster()) {
            SPSMultiblockData multiblock = (SPSMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.renderLocation != null;
        }
        return false;
    }
}

