/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.lib.effect.BoltEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;

public class BoltRenderer {
    private static final float REFRESH_TIME = 3.0f;
    private static final double MAX_OWNER_TRACK_TIME = 100.0;
    private Timestamp refreshTimestamp = new Timestamp();
    private final Random random = new Random();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final Map<Object, BoltOwnerData> boltOwners = new Object2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBoltsToRender() {
        Map<Object, BoltOwnerData> map = this.boltOwners;
        synchronized (map) {
            return this.boltOwners.values().stream().anyMatch(data -> !data.bolts.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn) {
        VertexConsumer buffer = bufferIn.m_6299_(MekanismRenderType.MEK_LIGHTNING);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Timestamp timestamp = new Timestamp(this.minecraft.f_91073_.m_46467_(), partialTicks);
        boolean refresh = timestamp.isPassed(this.refreshTimestamp, 0.3333333432674408);
        if (refresh) {
            this.refreshTimestamp = timestamp;
        }
        Map<Object, BoltOwnerData> map = this.boltOwners;
        synchronized (map) {
            Iterator<Map.Entry<Object, BoltOwnerData>> iter = this.boltOwners.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, BoltOwnerData> entry = iter.next();
                BoltOwnerData data = entry.getValue();
                if (refresh) {
                    data.bolts.removeIf(bolt -> bolt.tick(timestamp));
                }
                if (data.bolts.isEmpty() && data.lastBolt != null && data.lastBolt.getSpawnFunction().isConsecutive()) {
                    data.addBolt(new BoltInstance(data.lastBolt, timestamp), timestamp);
                }
                data.bolts.forEach(bolt -> bolt.render(matrix, buffer, timestamp));
                if (!data.bolts.isEmpty() || !timestamp.isPassed(data.lastUpdateTimestamp, 100.0)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object owner, BoltEffect newBoltData, float partialTicks) {
        if (this.minecraft.f_91073_ == null) {
            return;
        }
        Map<Object, BoltOwnerData> map = this.boltOwners;
        synchronized (map) {
            BoltOwnerData data = this.boltOwners.computeIfAbsent(owner, o -> new BoltOwnerData());
            data.lastBolt = newBoltData;
            Timestamp timestamp = new Timestamp(this.minecraft.f_91073_.m_46467_(), partialTicks);
            if ((!data.lastBolt.getSpawnFunction().isConsecutive() || data.bolts.isEmpty()) && timestamp.isPassed(data.lastBoltTimestamp, data.lastBoltDelay)) {
                data.addBolt(new BoltInstance(newBoltData, timestamp), timestamp);
            }
            data.lastUpdateTimestamp = timestamp;
        }
    }

    public static class Timestamp {
        private final long ticks;
        private final float partial;

        public Timestamp() {
            this(0L, 0.0f);
        }

        public Timestamp(long ticks, float partial) {
            this.ticks = ticks;
            this.partial = partial;
        }

        public Timestamp subtract(Timestamp other) {
            long newTicks = this.ticks - other.ticks;
            float newPartial = this.partial - other.partial;
            if (newPartial < 0.0f) {
                newPartial += 1.0f;
                --newTicks;
            }
            return new Timestamp(newTicks, newPartial);
        }

        public float value() {
            return (float)this.ticks + this.partial;
        }

        public boolean isPassed(Timestamp prev, double duration) {
            long ticksPassed = this.ticks - prev.ticks;
            if ((double)ticksPassed > duration) {
                return true;
            }
            if ((duration -= (double)ticksPassed) >= 1.0) {
                return false;
            }
            return (double)(this.partial - prev.partial) >= duration;
        }
    }

    public class BoltOwnerData {
        private final Set<BoltInstance> bolts = new ObjectOpenHashSet();
        private BoltEffect lastBolt;
        private Timestamp lastBoltTimestamp = new Timestamp();
        private Timestamp lastUpdateTimestamp = new Timestamp();
        private double lastBoltDelay;

        private void addBolt(BoltInstance instance, Timestamp timestamp) {
            this.bolts.add(instance);
            this.lastBoltDelay = instance.bolt.getSpawnFunction().getSpawnDelay(BoltRenderer.this.random);
            this.lastBoltTimestamp = timestamp;
        }
    }

    public static class BoltInstance {
        private final BoltEffect bolt;
        private final List<BoltEffect.BoltQuads> renderQuads;
        private final Timestamp createdTimestamp;

        public BoltInstance(BoltEffect bolt, Timestamp timestamp) {
            this.bolt = bolt;
            this.renderQuads = bolt.generate();
            this.createdTimestamp = timestamp;
        }

        public void render(Matrix4f matrix, VertexConsumer buffer, Timestamp timestamp) {
            float lifeScale = timestamp.subtract(this.createdTimestamp).value() / (float)this.bolt.getLifespan();
            BoltEffect.FadeFunction.RenderBounds bounds = this.bolt.getFadeFunction().getRenderBounds(this.renderQuads.size(), lifeScale);
            for (int i = bounds.start(); i < bounds.end(); ++i) {
                this.renderQuads.get(i).getVecs().forEach(v -> buffer.m_85982_(matrix, (float)v.f_82479_, (float)v.f_82480_, (float)v.f_82481_).m_6122_(this.bolt.getColor().r(), this.bolt.getColor().g(), this.bolt.getColor().b(), this.bolt.getColor().a()).m_5752_());
            }
        }

        public boolean tick(Timestamp timestamp) {
            return timestamp.isPassed(this.createdTimestamp, this.bolt.getLifespan());
        }
    }
}

