/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.data.ValveRenderData;
import net.minecraftforge.fluids.FluidStack;

public final class ModelRenderer {
    private static final int BLOCK_STAGES = 1000;
    private static final Map<RenderData, Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterData = new Object2ObjectOpenHashMap();
    private static final Map<ValveRenderData, MekanismRenderer.Model3D> cachedValveFluids = new Object2ObjectOpenHashMap();

    private ModelRenderer() {
    }

    public static int getStage(FluidStack stack, int stages, double scale) {
        return ModelRenderer.getStage(stack.getFluid().getAttributes().isGaseous(stack), stages, scale);
    }

    public static int getStage(boolean gaseous, int stages, double scale) {
        if (gaseous) {
            return stages - 1;
        }
        return Math.min(stages - 1, (int)(scale * (double)(stages - 1)));
    }

    public static MekanismRenderer.Model3D getModel(RenderData data, double scale) {
        Int2ObjectOpenHashMap cachedCenter;
        int maxStages = data.height * 1000;
        int stage = data.isGaseous() ? maxStages : Math.min(maxStages, (int)(scale * (double)maxStages));
        if (cachedCenterData.containsKey(data)) {
            cachedCenter = cachedCenterData.get(data);
            if (cachedCenter.containsKey(stage)) {
                return (MekanismRenderer.Model3D)cachedCenter.get(stage);
            }
        } else {
            cachedCenter = new Int2ObjectOpenHashMap();
            cachedCenterData.put(data, (Int2ObjectMap<MekanismRenderer.Model3D>)cachedCenter);
        }
        if (maxStages == 0) {
            stage = 1;
            maxStages = 1;
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(data.getTexture());
        cachedCenter.put(stage, (Object)model);
        model.minX = 0.01f;
        model.minY = 0.01f;
        model.minZ = 0.01f;
        model.maxX = (float)data.length - 0.02f;
        model.maxY = (float)data.height * ((float)stage / (float)maxStages) - 0.02f;
        model.maxZ = (float)data.width - 0.02f;
        return model;
    }

    public static float getActualHeight(MekanismRenderer.Model3D model) {
        return model.maxY + 0.02f;
    }

    public static MekanismRenderer.Model3D getValveModel(ValveRenderData data) {
        if (cachedValveFluids.containsKey(data)) {
            return cachedValveFluids.get(data);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        MekanismRenderer.prepFlowing(model, data.fluidType);
        cachedValveFluids.put(data, model);
        switch (data.side) {
            case DOWN: {
                model.minX = 0.3f;
                model.minY = 1.01f;
                model.minZ = 0.3f;
                model.maxX = 0.7f;
                model.maxY = 1.5f;
                model.maxZ = 0.7f;
                break;
            }
            case UP: {
                model.minX = 0.3f;
                model.minY = (float)(-data.height) - 0.01f;
                model.minZ = 0.3f;
                model.maxX = 0.7f;
                model.maxY = -0.01f;
                model.maxZ = 0.7f;
                break;
            }
            case NORTH: {
                model.minX = 0.3f;
                model.minY = (float)(-ModelRenderer.getValveFluidHeight(data)) + 0.02f;
                model.minZ = 1.02f;
                model.maxX = 0.7f;
                model.maxY = 0.7f;
                model.maxZ = 1.4f;
                break;
            }
            case SOUTH: {
                model.minX = 0.3f;
                model.minY = (float)(-ModelRenderer.getValveFluidHeight(data)) + 0.02f;
                model.minZ = -0.4f;
                model.maxX = 0.7f;
                model.maxY = 0.7f;
                model.maxZ = -0.03f;
                break;
            }
            case WEST: {
                model.minX = 1.02f;
                model.minY = (float)(-ModelRenderer.getValveFluidHeight(data)) + 0.02f;
                model.minZ = 0.3f;
                model.maxX = 1.4f;
                model.maxY = 0.7f;
                model.maxZ = 0.7f;
                break;
            }
            case EAST: {
                model.minX = -0.4f;
                model.minY = (float)(-ModelRenderer.getValveFluidHeight(data)) + 0.02f;
                model.minZ = 0.3f;
                model.maxX = -0.03f;
                model.maxY = 0.7f;
                model.maxZ = 0.7f;
            }
        }
        return model;
    }

    private static int getValveFluidHeight(ValveRenderData data) {
        return data.valveLocation.m_123342_() - data.location.m_123342_();
    }

    public static void resetCachedModels() {
        cachedCenterData.clear();
        cachedValveFluids.clear();
    }
}

