/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.baked;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;

public class MekanismModel
implements IMultipartModelGeometry<MekanismModel> {
    private final Multimap<String, BlockPartWrapper> elements;

    public MekanismModel(Multimap<String, BlockPartWrapper> list) {
        this.elements = list;
    }

    public Collection<BlockPartWrapper> getParts() {
        return this.elements.values();
    }

    public Optional<BlockPartWrapper> getPart(String name) {
        return this.elements.get((Object)name).stream().findFirst();
    }

    public static class BlockPartWrapper
    implements IModelGeometryPart {
        private final String name;
        private final BlockElement blockPart;
        private final Object2IntMap<BlockElementFace> litFaceMap = new Object2IntOpenHashMap();

        public BlockPartWrapper(String name, BlockElement blockPart) {
            this.name = name;
            this.blockPart = blockPart;
        }

        public BlockElement getPart() {
            return this.blockPart;
        }

        public String name() {
            return this.name;
        }

        public void light(Direction side, int light) {
            this.litFaceMap.put((Object)((BlockElementFace)this.blockPart.f_111310_.get(side)), light);
        }

        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            for (Map.Entry entry : this.blockPart.f_111310_.entrySet()) {
                BlockElementFace face = (BlockElementFace)entry.getValue();
                TextureAtlasSprite sprite = spriteGetter.apply(owner.resolveTexture(face.f_111356_));
                BakedQuad quad = BlockModel.makeBakedQuad((BlockElement)this.blockPart, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)((Direction)entry.getKey()), (ModelState)modelTransform, (ResourceLocation)modelLocation);
                if (this.litFaceMap.containsKey((Object)face)) {
                    quad = new Quad(quad).transform(QuadTransformation.light((float)this.litFaceMap.getInt((Object)face) / 15.0f)).bake();
                }
                if (face.f_111354_ == null) {
                    modelBuilder.addGeneralQuad(quad);
                    continue;
                }
                modelBuilder.addFaceQuad(modelTransform.m_6189_().rotateTransform(face.f_111354_), quad);
            }
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet textures = Sets.newHashSet();
            for (BlockElementFace face : this.blockPart.f_111310_.values()) {
                Material texture = owner.resolveTexture(face.f_111356_);
                if (Objects.equals(texture.m_119203_(), MissingTextureAtlasSprite.m_118071_())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.f_111356_, (Object)owner.getModelName()));
                }
                textures.add(texture);
            }
            return textures;
        }
    }

    public static class Loader
    implements IModelLoader<MekanismModel> {
        public static final Loader INSTANCE = new Loader();

        protected Loader() {
        }

        public void m_6213_(@Nonnull ResourceManager resourceManager) {
        }

        @Nonnull
        public MekanismModel read(@Nonnull JsonDeserializationContext ctx, @Nonnull JsonObject modelContents) {
            return new MekanismModel(Loader.readElements(ctx, modelContents));
        }

        protected static Multimap<String, BlockPartWrapper> readElements(@Nonnull JsonDeserializationContext ctx, @Nonnull JsonObject modelContents) {
            HashMultimap multimap = HashMultimap.create();
            if (modelContents.has("elements")) {
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)modelContents, (String)"elements")) {
                    JsonObject obj = element.getAsJsonObject();
                    BlockElement part = (BlockElement)ctx.deserialize(element, BlockElement.class);
                    String name = obj.has("name") ? obj.get("name").getAsString() : "undefined";
                    BlockPartWrapper wrapper = new BlockPartWrapper(name, part);
                    multimap.put((Object)name, (Object)wrapper);
                    if (!obj.has("faces")) continue;
                    JsonObject faces = obj.getAsJsonObject("faces");
                    faces.entrySet().forEach(e -> {
                        Direction side = Direction.m_122402_((String)((String)e.getKey()));
                        if (side == null) {
                            return;
                        }
                        JsonObject face = ((JsonElement)e.getValue()).getAsJsonObject();
                        if (face.has("lightLevel")) {
                            int light = face.get("lightLevel").getAsInt();
                            wrapper.light(side, light);
                        }
                    });
                }
            }
            return multimap;
        }
    }
}

