/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.lib.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class GuiRobitSkinSelectScroll
extends GuiElement {
    private static final int SLOT_DIMENSIONS = 48;
    private static final int SLOT_COUNT = 3;
    private static final int INNER_DIMENSIONS = 144;
    private final GuiScrollBar scrollBar;
    private final Supplier<List<RobitSkin>> unlockedSkins;
    private final EntityRobit robit;
    private RobitSkin selectedSkin;
    private float rotation;
    private int ticks;

    public GuiRobitSkinSelectScroll(IGuiWrapper gui, int x, int y, EntityRobit robit, Supplier<List<RobitSkin>> unlockedSkins) {
        super(gui, x, y, 156, 144);
        this.robit = robit;
        this.selectedSkin = this.robit.getSkin();
        this.unlockedSkins = unlockedSkins;
        this.scrollBar = this.addChild(new GuiScrollBar(gui, this.relativeX + 144, y, 144, () -> this.getUnlockedSkins() == null ? 0 : (int)Math.ceil((double)this.getUnlockedSkins().size() / 3.0), () -> 3));
    }

    private List<RobitSkin> getUnlockedSkins() {
        return this.unlockedSkins.get();
    }

    public RobitSkin getSelectedSkin() {
        return this.selectedSkin;
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int index = this.ticks / 10;
            float oldRot = this.rotation;
            this.rotation = Mth.m_14177_((float)(this.rotation - 0.5f));
            float rot = Mth.m_14189_((float)partialTicks, (float)oldRot, (float)this.rotation);
            int slotStart = this.scrollBar.getCurrentSelection() * 3;
            int max = 9;
            for (int i = 0; i < max; ++i) {
                int slotX = this.f_93620_ + i % 3 * 48;
                int slotY = this.f_93621_ + i / 3 * 48;
                int slot = slotStart + i;
                if (slot < skins.size()) {
                    RobitSkin skin = skins.get(slot);
                    if (skin == this.selectedSkin) {
                        GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE);
                    } else {
                        GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiElementHolder.HOLDER, 32);
                    }
                    this.renderRobit(matrix, skins.get(slot), slotX, slotY, rot, index);
                    continue;
                }
                GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiElementHolder.HOLDER, 32);
            }
        }
    }

    private static void renderSlotBackground(@Nonnull PoseStack matrix, int slotX, int slotY, ResourceLocation resource, int size) {
        GuiUtils.renderBackgroundTexture(matrix, resource, size, size, slotX, slotY, 48, 48, 256, 256);
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int xAxis = mouseX - this.getGuiLeft();
            int yAxis = mouseY - this.getGuiTop();
            int slotX = (xAxis - this.relativeX) / 48;
            int slotY = (yAxis - this.relativeY) / 48;
            if (slotX >= 0 && slotY >= 0 && slotX < 3 && slotY < 3) {
                int slot;
                int slotStartX = this.relativeX + slotX * 48;
                int slotStartY = this.relativeY + slotY * 48;
                if (xAxis >= slotStartX && xAxis < slotStartX + 48 && yAxis >= slotStartY && yAxis < slotStartY + 48 && (slot = (slotY + this.scrollBar.getCurrentSelection()) * 3 + slotX) < skins.size()) {
                    GuiRobitSkinSelectScroll.m_93172_((PoseStack)matrix, (int)slotStartX, (int)slotStartY, (int)(slotStartX + 48), (int)(slotStartY + 48), (int)1895819776);
                    MekanismRenderer.resetColor();
                }
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ticks;
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        RobitSkin skin = this.getSkin(mouseX, mouseY);
        if (skin != null) {
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.ROBIT_SKIN.translate(skin)});
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        RobitSkin skin = this.getSkin(mouseX, mouseY);
        if (skin != null) {
            this.selectedSkin = skin;
        }
    }

    private RobitSkin getSkin(double mouseX, double mouseY) {
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int slot;
            int slotX = (int)((mouseX - (double)this.f_93620_) / 48.0);
            int slotY = (int)((mouseY - (double)this.f_93621_) / 48.0);
            if (slotX >= 0 && slotY >= 0 && slotX < 3 && slotY < 3 && (slot = (slotY + this.scrollBar.getCurrentSelection()) * 3 + slotX) < skins.size()) {
                return skins.get(slot);
            }
        }
        return null;
    }

    private void renderRobit(PoseStack matrix, RobitSkin skin, int x, int y, float rotation, int index) {
        List<ResourceLocation> textures = skin.getTextures();
        if (textures.isEmpty()) {
            Mekanism.logger.error("Failed to render skin: {}, as it has no textures.", (Object)skin.getRegistryName());
            return;
        }
        BakedModel model = MekanismModelCache.INSTANCE.getRobitSkin(skin);
        if (model == null) {
            Mekanism.logger.warn("Failed to render skin: {} as it does not have a model.", (Object)skin.getRegistryName());
            return;
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(RobitSpriteUploader.RENDER_TYPE);
        matrix.m_85836_();
        matrix.m_85837_((double)(x + 48), (double)(y + 38), 0.0);
        matrix.m_85841_(48.0f, 48.0f, 48.0f);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        PoseStack.Pose matrixEntry = matrix.m_85850_();
        ModelDataMap modelData = new ModelDataMap.Builder().withInitial(EntityRobit.SKIN_TEXTURE_PROPERTY, (Object)MathUtils.getByIndexMod(textures, index)).build();
        List<BakedQuad> quads = model.getQuads(null, null, this.robit.f_19853_.f_46441_, (IModelData)modelData);
        quads = QuadUtils.transformBakedQuads(quads, new BasicRotationTransformation(rotation));
        for (BakedQuad quad : quads) {
            builder.putBulkData(matrixEntry, quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
        }
        buffer.m_109912_(RobitSpriteUploader.RENDER_TYPE);
        matrix.m_85849_();
    }

    private static class BasicRotationTransformation
    implements QuadTransformation {
        private static final double EPSILON = 10000.0;
        private static final Vec3 NORMAL = new Vec3(1.0, 0.0, 0.0);
        private final Quaternion quaternion;

        public BasicRotationTransformation(float rotation) {
            this.quaternion = new Quaternion(0.0, (double)rotation, 0.0, true);
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(this::consumeVertex);
        }

        private void consumeVertex(Vertex v) {
            v.pos(BasicRotationTransformation.round(this.quaternion.rotate(v.getPos().m_82492_(0.5, 0.5, 0.5)).m_82520_(0.5, 0.5, 0.5)));
            v.normal(NORMAL);
        }

        private static Vec3 round(Vec3 vec) {
            return new Vec3((double)Math.round(vec.f_82479_ * 10000.0) / 10000.0, (double)Math.round(vec.f_82480_ * 10000.0) / 10000.0, (double)Math.round(vec.f_82481_ * 10000.0) / 10000.0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof BasicRotationTransformation)) return false;
            BasicRotationTransformation other = (BasicRotationTransformation)o;
            if (!this.quaternion.equals(other.quaternion)) return false;
            return true;
        }

        public int hashCode() {
            return this.quaternion.hashCode();
        }
    }
}

