/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.reference.Ores;
import com.thevortex.potionsmaster.render.util.BlockData;
import com.thevortex.potionsmaster.render.util.BlockInfo;
import com.thevortex.potionsmaster.render.util.BlockStore;
import com.thevortex.potionsmaster.render.util.WorldRegion;
import com.thevortex.potionsmaster.render.util.xray.Controller;
import com.thevortex.potionsmaster.render.util.xray.Render;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class RenderEnqueue
implements Runnable {
    private final WorldRegion box;

    public RenderEnqueue(WorldRegion region) {
        this.box = region;
    }

    public static void checkBlock(BlockPos pos, BlockState state, boolean add) {
        if (!Controller.drawOres() || Controller.getBlockStore().getStore().isEmpty()) {
            return;
        }
        String defaultState = state.m_60734_().m_49966_().toString();
        if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
            if (!add) {
                Render.ores.remove(new BlockInfo((Vec3i)pos, null, 0.0));
                return;
            }
            BlockData data = null;
            if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
                data = Controller.getBlockStore().getStore().get(defaultState);
            }
            if (data == null) {
                return;
            }
            double alpha = Math.max(0.0, ((double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) / (double)Controller.getRadius() * 255.0);
            Render.ores.add(new BlockInfo(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), data.getColor().getColor(), alpha));
        }
    }

    @Override
    public void run() {
        this.blockFinder();
    }

    private void blockFinder() {
        HashMap<UUID, BlockData> blocks = Controller.getBlockStore().getStore();
        if (blocks.isEmpty() && !Render.ores.isEmpty()) {
            Render.ores.clear();
        }
        Level world = PotionsMaster.proxy.getClientPlayer().f_19853_;
        LocalPlayer player = PotionsMaster.proxy.getClientPlayer();
        ArrayList<BlockInfo> renderQueue = new ArrayList<BlockInfo>();
        for (int chunkX = this.box.minChunkX; chunkX <= this.box.maxChunkX; ++chunkX) {
            int x = chunkX << 4;
            int lowBoundX = x < this.box.minX ? this.box.minX - x : 0;
            int highBoundX = x + 15 > this.box.maxX ? this.box.maxX - x : 15;
            for (int chunkZ = this.box.minChunkZ; chunkZ <= this.box.maxChunkZ; ++chunkZ) {
                if (!world.m_7232_(chunkX, chunkZ)) continue;
                LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
                LevelChunkSection[] extendsList = chunk.m_7103_();
                int z = chunkZ << 4;
                int lowBoundZ = z < this.box.minZ ? this.box.minZ - z : 0;
                int highBoundZ = z + 15 > this.box.maxZ ? this.box.maxZ - z : 15;
                for (int curExtend = this.box.minChunkY; curExtend <= this.box.maxChunkY; ++curExtend) {
                    LevelChunkSection ebs = extendsList[curExtend + (Math.abs(chunk.m_141937_()) >> 4)];
                    if (ebs == null) continue;
                    int y = curExtend << 4;
                    int lowBoundY = y < this.box.minY ? this.box.minY - y : 0;
                    int highBoundY = y + 15 > this.box.maxY ? this.box.maxY - y : 15;
                    for (int i = lowBoundX; i <= highBoundX; ++i) {
                        for (int j = lowBoundY; j <= highBoundY; ++j) {
                            for (int k = lowBoundZ; k <= highBoundZ; ++k) {
                                BlockStore.BlockDataWithUUID dataWithUUID;
                                BlockState currentState = ebs.m_62982_(i, j, k);
                                Optional firstTag = currentState.m_204343_().findFirst();
                                if (!firstTag.isPresent()) continue;
                                TagKey<Block> block = (TagKey<Block>)firstTag.get();
                                if (currentState.m_204336_(Ores.DIAMOND)) {
                                    block = Ores.DIAMOND;
                                }
                                if (currentState.m_204336_(Ores.LAPIS)) {
                                    block = Ores.LAPIS;
                                }
                                if (currentState.m_204336_(Ores.ALUMINIUM)) {
                                    block = Ores.ALUMINIUM;
                                }
                                if (currentState.m_204336_(Ores.COPPER)) {
                                    block = Ores.COPPER;
                                }
                                if (currentState.m_204336_(Ores.TIN)) {
                                    block = Ores.TIN;
                                }
                                if (currentState.m_204336_(Ores.LEAD)) {
                                    block = Ores.LEAD;
                                }
                                if (currentState.m_204336_(Ores.SILVER)) {
                                    block = Ores.SILVER;
                                }
                                if (currentState.m_204336_(Ores.GOLD)) {
                                    block = Ores.GOLD;
                                }
                                if (currentState.m_204336_(Ores.URANIUM)) {
                                    block = Ores.URANIUM;
                                }
                                if (currentState.m_204336_(Ores.NICKEL)) {
                                    block = Ores.NICKEL;
                                }
                                if (currentState.m_204336_(Ores.IRON)) {
                                    block = Ores.IRON;
                                }
                                if (currentState.m_204336_(Ores.OSMIUM)) {
                                    block = Ores.OSMIUM;
                                }
                                if (currentState.m_204336_(Ores.ZINC)) {
                                    block = Ores.ZINC;
                                }
                                if (currentState.m_204336_(Ores.EMERALD)) {
                                    block = Ores.EMERALD;
                                }
                                if (currentState.m_204336_(Ores.COAL)) {
                                    block = Ores.COAL;
                                }
                                if (currentState.m_204336_(Ores.REDSTONE)) {
                                    block = Ores.REDSTONE;
                                }
                                if (currentState.m_204336_(Ores.QUARTZ)) {
                                    block = Ores.QUARTZ;
                                }
                                if (currentState.m_204336_(Ores.BISMUTH)) {
                                    block = Ores.BISMUTH;
                                }
                                if (currentState.m_204336_(Ores.CRIMSONIRON)) {
                                    block = Ores.CRIMSONIRON;
                                }
                                if (currentState.m_204336_(Ores.PLATINUM)) {
                                    block = Ores.PLATINUM;
                                }
                                if (currentState.m_204336_(Ores.NETHERITE)) {
                                    block = Ores.NETHERITE;
                                }
                                if (currentState.m_204336_(Ores.ALLTHEMODIUM)) {
                                    block = Ores.ALLTHEMODIUM;
                                }
                                if (currentState.m_204336_(Ores.VIBRANIUM)) {
                                    block = Ores.VIBRANIUM;
                                }
                                if (currentState.m_204336_(Ores.UNOBTAINIUM)) {
                                    block = Ores.UNOBTAINIUM;
                                }
                                if ((dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString())) == null || dataWithUUID.getBlockData() == null || !dataWithUUID.getBlockData().isDrawing()) continue;
                                double alpha = Math.max(0.0, (double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().m_20275_((double)(x + i), (double)(y + j), (double)(z + k)) / (double)(Controller.getRadius() / 4));
                                renderQueue.add(new BlockInfo(x + i, y + j, z + k, dataWithUUID.getBlockData().getColor().getColor(), alpha));
                            }
                        }
                    }
                }
            }
        }
        renderQueue.sort((t, t1) -> Double.compare(t1.m_123331_(new Vec3i(player.m_20185_(), player.m_20186_(), player.m_20189_())), t.m_123331_(new Vec3i(player.m_20185_(), player.m_20186_(), player.m_20189_()))));
        Render.ores.clear();
        Render.ores.addAll(renderQueue);
    }
}

