/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.loot.modifier;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddItemModifier
extends LootModifier {
    private final Item addedItem;
    private final int count;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item addedItemIn, int count) {
        super(conditionsIn);
        this.addedItem = addedItemIn;
        this.count = count;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack addedStack = new ItemStack((ItemLike)this.addedItem, this.count);
        if (addedStack.m_41613_() < addedStack.m_41741_()) {
            generatedLoot.add(addedStack);
        } else {
            ItemStack subStack;
            for (int i = addedStack.m_41613_(); i > 0; i -= subStack.m_41613_()) {
                subStack = addedStack.m_41777_();
                subStack.m_41764_(Math.min(addedStack.m_41741_(), i));
                generatedLoot.add(subStack);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemModifier> {
        public AddItemModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            Item addedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"item")));
            int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
            return new AddItemModifier(ailootcondition, addedItem, count);
        }

        public JsonObject write(AddItemModifier instance) {
            return new JsonObject();
        }
    }
}

