/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.Level;

public class NBTUtil {
    public static Tag toDirectNBT(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return ByteTag.m_128266_((byte)((byte)(bool != false ? 1 : 0)));
        }
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            return IntTag.m_128679_((int)integer);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return DoubleTag.m_128500_((double)number.doubleValue());
        }
        if (object instanceof String) {
            return StringTag.m_129297_((String)object.toString());
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry item : map.entrySet()) {
                Tag value = NBTUtil.toDirectNBT(item.getValue());
                if (item.getKey() == null || value == null) continue;
                nbt.m_128365_(item.getKey().toString(), value);
            }
            return nbt;
        }
        return null;
    }

    public static CompoundTag fromText(String json) {
        try {
            return json == null ? null : TagParser.m_129359_((String)json);
        }
        catch (CommandSyntaxException ex) {
            AdvancedPeripherals.debug("Could not parse json data to NBT", Level.ERROR);
            ex.printStackTrace();
            return null;
        }
    }

    public static CompoundTag fromBinary(String base64) {
        CompoundTag compoundTag;
        block9: {
            if (base64 == null) {
                return null;
            }
            InputStream inputStream = Base64.getDecoder().wrap(new ByteArrayInputStream(base64.getBytes()));
            try {
                compoundTag = NbtIo.m_128939_((InputStream)inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    AdvancedPeripherals.debug("Could not parse binary data to NBT", Level.ERROR);
                    ex.printStackTrace();
                    return null;
                }
            }
            inputStream.close();
        }
        return compoundTag;
    }

    public static CompoundTag toNBT(BlockPos pos) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("x", pos.m_123341_());
        data.m_128405_("y", pos.m_123342_());
        data.m_128405_("z", pos.m_123343_());
        return data;
    }

    public static BlockPos blockPosFromNBT(CompoundTag nbt) {
        return new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
    }

    public static CompoundTag toNBT(ChunkPos pos) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("x", pos.f_45578_);
        data.m_128405_("z", pos.f_45579_);
        return data;
    }

    public static ChunkPos chunkPosFromNBT(CompoundTag nbt) {
        return new ChunkPos(nbt.m_128451_("x"), nbt.m_128451_("z"));
    }
}

