/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.configuration;

import de.srendi.advancedperipherals.common.addons.computercraft.operations.AutomataCoreTier;
import de.srendi.advancedperipherals.common.configuration.IAPConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class MetaphysicsConfig
implements IAPConfig {
    public final ForgeConfigSpec.IntValue energyToFuelRate;
    public final ForgeConfigSpec.BooleanValue enableWeakAutomataCore;
    public final ForgeConfigSpec.BooleanValue enableEndAutomataCore;
    public final ForgeConfigSpec.BooleanValue enableHusbandryAutomataCore;
    public final ForgeConfigSpec.IntValue endAutomataCoreWarpPointLimit;
    public final ForgeConfigSpec.DoubleValue overpoweredAutomataBreakChance;
    private final ForgeConfigSpec configSpec;

    public MetaphysicsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Config for metaphysics").push("Metaphysics");
        this.energyToFuelRate = builder.comment("Defines energy to fuel rate").defineInRange("energyToFuelRate", 575, 575, Integer.MAX_VALUE);
        this.enableWeakAutomataCore = builder.define("enableWeakAutomataCore", true);
        this.enableEndAutomataCore = builder.define("enableEndAutomataCore", true);
        this.enableHusbandryAutomataCore = builder.define("enableHusbandryAutomataCore", true);
        this.endAutomataCoreWarpPointLimit = builder.comment("Defines max warp point stored in warp core. Mostly need to not allow NBT overflow error").defineInRange("endAutomataCoreWarpPointLimit", 64, 1, Integer.MAX_VALUE);
        this.overpoweredAutomataBreakChance = builder.comment("Chance that overpowered automata will break after rotation cycle").defineInRange("overpoweredAutomataBreakChance", 0.002, 0.0, 1.0);
        this.register(AutomataCoreTier.values(), builder);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public String getFileName() {
        return "metaphysics";
    }

    @Override
    public ModConfig.Type getType() {
        return ModConfig.Type.COMMON;
    }
}

