/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.argoggles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ARRenderHelper
extends GuiComponent {
    private static final ARRenderHelper INSTANCE = new ARRenderHelper();

    public static void drawRightboundString(PoseStack matrixStack, Font fontRenderer, String text, int x, int y, int color) {
        ARRenderHelper.m_93236_((PoseStack)matrixStack, (Font)fontRenderer, (String)text, (int)(x - fontRenderer.m_92895_(text)), (int)y, (int)color);
    }

    public static ARRenderHelper getInstance() {
        return INSTANCE;
    }

    public static int fixAlpha(int color) {
        return (color & 0xFF000000) == 0 ? color | 0xFF000000 : color;
    }

    public void m_93154_(@NotNull PoseStack matrixStack, int minX, int maxX, int y, int color) {
        color = ARRenderHelper.fixAlpha(color);
        super.m_93154_(matrixStack, minX, maxX, y, color);
    }

    public void m_93222_(@NotNull PoseStack matrixStack, int x, int minY, int maxY, int color) {
        color = ARRenderHelper.fixAlpha(color);
        super.m_93222_(matrixStack, x, minY, maxY, color);
    }

    protected void m_93179_(@NotNull PoseStack matrixStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        colorFrom = ARRenderHelper.fixAlpha(colorFrom);
        colorTo = ARRenderHelper.fixAlpha(colorTo);
        super.m_93179_(matrixStack, x1, y1, x2, y2, colorFrom, colorTo);
    }

    public void drawCircle(PoseStack matrixStack, int centerX, int centerY, float radius, int color) {
        color = ARRenderHelper.fixAlpha(color);
        int nSegments = 360;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float z = this.m_93252_();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < 360; ++i) {
            double angle = Math.PI * 2 * (double)i / 360.0;
            float xd = (float)((double)radius * Math.sin(angle));
            float yd = (float)((double)radius * Math.cos(angle));
            bufferbuilder.m_85982_(matrix, (float)centerX + xd, (float)centerY + yd, z).m_85950_(r, g, b, a).m_5752_();
        }
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public void fillCircle(PoseStack matrixStack, int centerX, int centerY, float radius, int color) {
        color = ARRenderHelper.fixAlpha(color);
        float increment = 0.5f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float z = this.m_93252_();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        for (float y = (float)centerY - radius; y < (float)centerY + radius; y += 0.5f) {
            float yd = (float)centerY - y;
            float xd = (float)Math.sqrt(Math.pow(radius, 2.0) - Math.pow(yd, 2.0));
            bufferbuilder.m_85982_(matrix, (float)centerX - xd, y, z).m_85950_(r, g, b, a).m_5752_();
            bufferbuilder.m_85982_(matrix, (float)centerX + xd, y, z).m_85950_(r, g, b, a).m_5752_();
        }
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public void drawItemIcon(PoseStack matrixStack, ItemRenderer itemRenderer, String item, int x, int y) {
        ItemStack stack = new ItemStack((ItemLike)ItemUtil.getRegistryEntry(item, ForgeRegistries.ITEMS));
        itemRenderer.m_115123_(stack, x, y);
    }
}

