/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.Action;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorage;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.blocks.blockentities.RsBridgeEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RsBridgePeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<RsBridgeEntity>> {
    public static final String TYPE = "rsBridge";

    public RsBridgePeripheral(RsBridgeEntity tileEntity) {
        super(TYPE, new BlockEntityPeripheralOwner<RsBridgeEntity>(tileEntity));
    }

    private RefinedStorageNode getNode() {
        return (RefinedStorageNode)((RsBridgeEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).getNode();
    }

    private INetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    private Object ensureIsConnected(Object defaultValue, Supplier<Object> returnValue) {
        if (!this.isConnected() || !this.getNetwork().canRun()) {
            return defaultValue;
        }
        return returnValue.get();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableRSBridge.get();
    }

    @LuaFunction(mainThread=true)
    public final boolean isConnected() {
        return this.getNetwork() != null;
    }

    @LuaFunction(mainThread=true)
    public final Object listItems() {
        return this.ensureIsConnected(null, () -> RefinedStorage.listItems(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final Object listCraftableItems() {
        if (!this.isConnected()) {
            return null;
        }
        ArrayList items = new ArrayList();
        RefinedStorage.getCraftableItems(this.getNetwork()).forEach(item -> items.add(RefinedStorage.getObjectFromStack(item, this.getNetwork())));
        return items;
    }

    @LuaFunction(mainThread=true)
    public final Object listCraftableFluids() {
        if (!this.isConnected()) {
            return null;
        }
        ArrayList fluids = new ArrayList();
        RefinedStorage.getCraftableFluids(this.getNetwork()).forEach(fluid -> fluids.add(RefinedStorage.getObjectFromFluid(fluid, this.getNetwork())));
        return fluids;
    }

    @LuaFunction(mainThread=true)
    public final int getMaxItemDiskStorage() {
        return (Integer)this.ensureIsConnected(0, () -> RefinedStorage.getMaxItemDiskStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final int getMaxFluidDiskStorage() {
        return (Integer)this.ensureIsConnected(0, () -> RefinedStorage.getMaxFluidDiskStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final int getMaxItemExternalStorage() {
        return (Integer)this.ensureIsConnected(0, () -> RefinedStorage.getMaxItemExternalStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final int getMaxFluidExternalStorage() {
        return (Integer)this.ensureIsConnected(0, () -> RefinedStorage.getMaxFluidExternalStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final Object listFluids() {
        return this.ensureIsConnected(null, () -> RefinedStorage.listFluids(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final int getEnergyUsage() {
        return (Integer)this.ensureIsConnected(0, () -> this.getNetwork().getEnergyUsage());
    }

    @LuaFunction(mainThread=true)
    public final int getMaxEnergyStorage() {
        return (Integer)this.ensureIsConnected(0, () -> this.getNetwork().getEnergyStorage().getMaxEnergyStored());
    }

    @LuaFunction(mainThread=true)
    public final int getEnergyStorage() {
        return (Integer)this.ensureIsConnected(0, () -> this.getNetwork().getEnergyStorage().getEnergyStored());
    }

    @LuaFunction(mainThread=true)
    public final Object getPattern(IArguments arguments) {
        return this.ensureIsConnected(null, () -> {
            try {
                return RefinedStorage.getObjectFromPattern(this.getNetwork().getCraftingManager().getPattern(ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()))), this.getNetwork());
            }
            catch (LuaException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @LuaFunction(mainThread=true)
    public final int exportItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        if (!this.isConnected()) {
            return 0;
        }
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        Direction direction = this.validateSide(arguments.getString(1));
        BlockEntity targetEntity = ((RsBridgeEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).m_58904_().m_7702_(((RsBridgeEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).m_58899_().m_142300_(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + arguments.getString(1));
        }
        ItemStack extracted = this.getNetwork().extractItem(stack, stack.m_41613_(), 1, Action.SIMULATE);
        if (extracted.m_41619_()) {
            return 0;
        }
        int transferableAmount = extracted.m_41613_();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted, (boolean)true);
        if (!remaining.m_41619_()) {
            transferableAmount -= remaining.m_41613_();
        }
        if (!(remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)(extracted = this.getNetwork().extractItem(stack, transferableAmount, 1, Action.PERFORM)), (boolean)false)).m_41619_()) {
            this.getNetwork().insertItem(remaining, remaining.m_41613_(), Action.PERFORM);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        if (!this.isConnected()) {
            return 0;
        }
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        Direction direction = this.validateSide(arguments.getString(1));
        BlockEntity targetEntity = ((RsBridgeEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).m_58904_().m_7702_(((RsBridgeEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).m_58899_().m_142300_(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + arguments.getString(1));
        }
        int amount = stack.m_41613_();
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack insertedStack;
            if (!inventory.getStackInSlot(i).m_41656_(stack)) continue;
            if (inventory.getStackInSlot(i).m_41613_() >= amount) {
                insertedStack = this.getNetwork().insertItem(stack, amount, Action.PERFORM);
                inventory.extractItem(i, amount - insertedStack.m_41613_(), false);
                transferableAmount += amount - insertedStack.m_41613_();
                break;
            }
            amount -= inventory.getStackInSlot(i).m_41613_();
            insertedStack = this.getNetwork().insertItem(stack, inventory.getStackInSlot(i).m_41613_(), Action.PERFORM);
            inventory.extractItem(i, inventory.getStackInSlot(i).m_41613_() - insertedStack.m_41613_(), false);
            transferableAmount += inventory.getStackInSlot(i).m_41613_() - insertedStack.m_41613_();
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int exportItemToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        if (!this.isConnected()) {
            return 0;
        }
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        if (chest == null) {
            throw new LuaException("No valid inventory block for " + arguments.getString(1));
        }
        BlockEntity targetEntity = (BlockEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        ItemStack extracted = this.getNetwork().extractItem(stack, stack.m_41613_(), 1, Action.SIMULATE);
        if (extracted.m_41619_()) {
            return 0;
        }
        int transferableAmount = extracted.m_41613_();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted, (boolean)true);
        if (!remaining.m_41619_()) {
            transferableAmount -= remaining.m_41613_();
        }
        if (!(remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)(extracted = this.getNetwork().extractItem(stack, transferableAmount, 1, Action.PERFORM)), (boolean)false)).m_41619_()) {
            this.getNetwork().insertItem(remaining, remaining.m_41613_(), Action.PERFORM);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItemFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        if (!this.isConnected()) {
            return 0;
        }
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        int count = stack.m_41613_();
        if (chest == null) {
            throw new LuaException("No inventory block for " + arguments.getString(1));
        }
        BlockEntity targetEntity = (BlockEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack insertedStack;
            if (!inventory.getStackInSlot(i).m_41656_(stack)) continue;
            if (inventory.getStackInSlot(i).m_41613_() >= amount) {
                insertedStack = this.getNetwork().insertItem(stack, amount, Action.PERFORM);
                inventory.extractItem(i, amount - insertedStack.m_41613_(), false);
                transferableAmount += amount - insertedStack.m_41613_();
                break;
            }
            amount = count - inventory.getStackInSlot(i).m_41613_();
            insertedStack = this.getNetwork().insertItem(stack, inventory.getStackInSlot(i).m_41613_(), Action.PERFORM);
            inventory.extractItem(i, inventory.getStackInSlot(i).m_41613_() - insertedStack.m_41613_(), false);
            transferableAmount += inventory.getStackInSlot(i).m_41613_() - insertedStack.m_41613_();
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final Object getItem(IArguments arguments) throws LuaException {
        return this.ensureIsConnected(null, () -> {
            try {
                return RefinedStorage.getItem(this.getNetwork(), ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork())));
            }
            catch (LuaException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @LuaFunction(mainThread=true)
    public final boolean craftItem(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return false;
        }
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        if (stack == null) {
            throw new LuaException("The item " + arguments.getTable(0).get("name") + "is not craftable");
        }
        ICalculationResult result = this.getNetwork().getCraftingManager().create(stack, stack.m_41613_());
        CalculationResultType type = result.getType();
        if (result.getType() == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        return type == CalculationResultType.OK;
    }

    @LuaFunction(mainThread=true)
    public final boolean craftFluid(String fluid, int count) {
        if (!this.isConnected()) {
            return false;
        }
        ICalculationResult result = this.getNetwork().getCraftingManager().create(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)), 0), count);
        CalculationResultType type = result.getType();
        if (result.getType() == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        return type == CalculationResultType.OK;
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCrafting(String item) {
        if (!this.isConnected()) {
            return false;
        }
        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)));
        for (ICraftingTask task : this.getNetwork().getCraftingManager().getTasks()) {
            ItemStack taskStack = task.getRequested().getItem();
            if (!taskStack.m_41656_(stack)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCraftable(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return false;
        }
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        return RefinedStorage.isItemCraftable(this.getNetwork(), stack);
    }
}

