/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import com.google.common.collect.UnmodifiableIterator;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.CraftJob;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.MeBridgeEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.InventoryUtil;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class MeBridgePeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<MeBridgeEntity>> {
    public static final String TYPE = "meBridge";
    private final MeBridgeEntity tile;
    private IGridNode node;

    public MeBridgePeripheral(MeBridgeEntity tileEntity) {
        super(TYPE, new BlockEntityPeripheralOwner<MeBridgeEntity>(tileEntity));
        this.tile = tileEntity;
        this.node = tileEntity.getActionableNode();
    }

    public void setNode(IManagedGridNode node) {
        this.node = node.getNode();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableMEBridge.get();
    }

    private ICraftingService getCraftingService() {
        return this.node.getGrid().getCraftingService();
    }

    protected long exportToChest(@NotNull IArguments arguments, @NotNull IItemHandler targetInventory) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), monitor);
        AEItemKey targetStack = AEItemKey.of((ItemStack)stack);
        if (targetStack == null) {
            throw new LuaException("Illegal AE2 state ...");
        }
        long extracted = monitor.extract((AEKey)targetStack, (long)stack.m_41613_(), Actionable.SIMULATE, this.tile.getActionSource());
        if (extracted == 0L) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        long transferableAmount = extracted;
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)stack, (boolean)true);
        if (!remaining.m_41619_()) {
            transferableAmount -= (long)remaining.m_41613_();
        }
        if (transferableAmount == 0L) {
            return transferableAmount;
        }
        extracted = monitor.extract((AEKey)targetStack, transferableAmount, Actionable.MODULATE, this.tile.getActionSource());
        stack.m_41764_((int)extracted);
        remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)stack, (boolean)false);
        if (!remaining.m_41619_()) {
            monitor.insert((AEKey)AEItemKey.of((ItemStack)remaining), (long)remaining.m_41613_(), Actionable.MODULATE, this.tile.getActionSource());
        }
        return transferableAmount;
    }

    protected int importToME(@NotNull IArguments arguments, @NotNull IItemHandler targetInventory) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), monitor);
        AEItemKey aeStack = AEItemKey.of((ItemStack)stack);
        int amount = stack.m_41613_();
        if (aeStack == null) {
            throw new LuaException("Illegal AE2 state ...");
        }
        if (stack.m_41613_() == 0) {
            return 0;
        }
        int transferableAmount = 0;
        for (int i = 0; i < targetInventory.getSlots(); ++i) {
            if (!targetInventory.getStackInSlot(i).m_41656_(stack)) continue;
            int countInSlot = targetInventory.getStackInSlot(i).m_41613_();
            int extractCount = Math.min(countInSlot, amount);
            amount -= extractCount;
            int extracted = (int)monitor.insert((AEKey)aeStack, (long)extractCount, Actionable.MODULATE, this.tile.getActionSource());
            targetInventory.extractItem(i, extracted, false);
            transferableAmount += extracted;
        }
        return transferableAmount;
    }

    @LuaFunction
    public final MethodResult craftItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        ItemStack itemToCraft = ItemUtil.getItemStack(arguments.getTable(0), monitor);
        if (itemToCraft.m_41619_()) {
            return MethodResult.of((Object[])new Object[]{false, "Item " + itemToCraft + " does not exists"});
        }
        CraftJob job = new CraftJob(((BlockEntityPeripheralOwner)this.owner).getLevel(), computer, this.node, itemToCraft, this.tile, this.tile);
        this.tile.addJob(job);
        ServerWorker.add(job::startCrafting);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final double getEnergyUsage() {
        return this.node.getGrid().getEnergyService().getAvgPowerUsage();
    }

    @LuaFunction(mainThread=true)
    public final double getEnergyStorage() {
        return this.node.getGrid().getEnergyService().getStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final double getAvgPowerUsage() {
        return this.node.getGrid().getEnergyService().getAvgPowerUsage();
    }

    @LuaFunction(mainThread=true)
    public final double getAvgPowerInjection() {
        return this.node.getGrid().getEnergyService().getAvgPowerInjection();
    }

    @LuaFunction(mainThread=true)
    public final double getMaxEnergyStorage() {
        return this.node.getGrid().getEnergyService().getMaxStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCrafting(IArguments arguments) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        ICraftingService grid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        ItemStack itemStack = ItemUtil.getItemStack(arguments.getTable(0), monitor);
        return AppEngApi.isItemCrafting(monitor, grid, itemStack);
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCraftable(IArguments arguments) throws LuaException {
        ICraftingService crafting;
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        Pair<Long, AEItemKey> stack = AppEngApi.findAEStackFromItemStack(monitor, crafting = (ICraftingService)this.node.getGrid().getService(ICraftingService.class), ItemUtil.getItemStack(arguments.getTable(0), monitor));
        if (stack == null) {
            return false;
        }
        return this.getCraftingService().isCraftable((AEKey)stack.getRight());
    }

    @LuaFunction(mainThread=true)
    public final long exportItem(@NotNull IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.exportToChest(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final long exportItemToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.exportToChest(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final int importItem(IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.importToME(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final int importItemFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.importToME(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getItem(IArguments arguments) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), monitor);
        if (stack.m_41619_()) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot determinate item for search"});
        }
        for (Object2LongMap.Entry potentialStack : monitor.getAvailableStacks()) {
            AEItemKey itemKey;
            Object object = potentialStack.getKey();
            if (!(object instanceof AEItemKey) || !(itemKey = (AEItemKey)object).matches(stack)) continue;
            return MethodResult.of(AppEngApi.getObjectFromStack(new Pair<Long, AEItemKey>(potentialStack.getLongValue(), itemKey), this.getCraftingService()));
        }
        return MethodResult.of(null);
    }

    @LuaFunction(mainThread=true)
    public final Object[] listItems() {
        return new Object[]{AppEngApi.listStacks(AppEngApi.getMonitor(this.node), this.getCraftingService(), 0)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableItems() {
        return new Object[]{AppEngApi.listStacks(AppEngApi.getMonitor(this.node), this.getCraftingService(), 2)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listFluid() {
        return new Object[]{AppEngApi.listFluids(AppEngApi.getMonitor(this.node), this.getCraftingService(), 0)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableFluid() {
        return new Object[]{AppEngApi.listFluids(AppEngApi.getMonitor(this.node), this.getCraftingService(), 2)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getCraftingCPUs() throws LuaException {
        ICraftingService grid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        if (grid == null) {
            throw new LuaException("Not connected");
        }
        HashMap<Integer, Map<String, Object>> map = new HashMap<Integer, Map<String, Object>>();
        UnmodifiableIterator iterator = grid.getCpus().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        int i = 1;
        while (iterator.hasNext()) {
            Map<String, Object> o = AppEngApi.getObjectFromCPU((ICraftingCPU)iterator.next());
            map.put(i++, o);
        }
        return new Object[]{map};
    }
}

