/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.operations;

import de.srendi.advancedperipherals.lib.metaphysics.IAutomataCoreTier;
import net.minecraftforge.common.ForgeConfigSpec;

public enum AutomataCoreTier implements IAutomataCoreTier
{
    TIER1(2, 2),
    TIER2(4, 3),
    OVERPOWERED_TIER1(4, 3),
    OVERPOWERED_TIER2(6, 4);

    private final int defaultInteractionRadius;
    private final int defaultMaxFuelConsumptionRate;
    private ForgeConfigSpec.IntValue interactionRadius;
    private ForgeConfigSpec.IntValue maxFuelConsumptionRate;

    private AutomataCoreTier(int defaultInteractionRadius, int defaultMaxFuelConsumptionRate) {
        this.defaultInteractionRadius = defaultInteractionRadius;
        this.defaultMaxFuelConsumptionRate = defaultMaxFuelConsumptionRate;
    }

    @Override
    public int getInteractionRadius() {
        if (this.interactionRadius == null) {
            return 0;
        }
        return (Integer)this.interactionRadius.get();
    }

    @Override
    public int getMaxFuelConsumptionRate() {
        if (this.maxFuelConsumptionRate == null) {
            return 0;
        }
        return (Integer)this.maxFuelConsumptionRate.get();
    }

    @Override
    public void addToConfig(ForgeConfigSpec.Builder builder) {
        this.interactionRadius = builder.defineInRange(this.settingsName() + "InteractionRadius", this.defaultInteractionRadius, 1, 64);
        this.maxFuelConsumptionRate = builder.defineInRange(this.settingsName() + "MaxFuelConsumptionRate", this.defaultMaxFuelConsumptionRate, 1, 32);
    }

    @Override
    public String settingsPostfix() {
        return "AutomataCore";
    }
}

