/*
 * Decompiled with CFR 0.152.
 */
package com.gamma1772.additionalbars.content.block;

import com.gamma1772.additionalbars.content.block.BlockType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HorizontalBarsSlabBlock
extends SlabBlock
implements SimpleWaterloggedBlock {
    private final ArrayList<String> blockTypes = new ArrayList();
    private static final EnumProperty<SlabType> TYPE = BlockStateProperties.f_61397_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_BOT = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_COM = Shapes.m_83110_((VoxelShape)SHAPE_BOT, (VoxelShape)SHAPE_TOP);

    public HorizontalBarsSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public HorizontalBarsSlabBlock(BlockBehaviour.Properties properties, BlockType ... types) {
        super(properties);
        if (types.length != 0) {
            for (BlockType type : types) {
                this.blockTypes.add(type.getText());
            }
        }
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.m_61143_(TYPE);
        return switch (slabType) {
            case SlabType.DOUBLE -> SHAPE_COM;
            case SlabType.TOP -> SHAPE_TOP;
            default -> SHAPE_BOT;
        };
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        BlockState blockState = ctx.m_43725_().m_8055_(blockPos);
        FluidState fluidState = ctx.m_43725_().m_6425_(blockPos);
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockState.m_61124_(TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        BlockState blockState2 = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Direction direction = ctx.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && ctx.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) ? blockState2 : (BlockState)blockState2.m_61124_(TYPE, (Comparable)SlabType.TOP);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltips, TooltipFlag flag) {
        if (!this.blockTypes.isEmpty()) {
            for (String type : this.blockTypes) {
                if (type.equals("oxidizing") || type.equals("waxed")) {
                    tooltips.add((Component)new TranslatableComponent("tooltip.gamma1772." + type).m_130940_(ChatFormatting.AQUA));
                    continue;
                }
                if (!type.equals("regular")) {
                    if (!type.equals("nether")) {
                        tooltips.add((Component)new TranslatableComponent("tooltip.gamma1772." + type).m_130940_(ChatFormatting.GREEN));
                        continue;
                    }
                    tooltips.add((Component)new TranslatableComponent("tooltip.gamma1772." + type).m_130940_(ChatFormatting.DARK_RED));
                    continue;
                }
                tooltips.add((Component)new TranslatableComponent("tooltip.gamma1772." + type).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

