/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.registry;

import com.google.common.reflect.Reflection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.woodcutter.WoodCutterMod;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.item.WoodcutterItem;
import ovh.corail.woodcutter.registry.ModRecipeTypes;
import ovh.corail.woodcutter.registry.ModStats;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static final Set<Block> WOODCUTTERS = new HashSet<Block>();
    public static final Set<Item> WOODCUTTER_ITEMS = new HashSet<Item>();
    private static final Random RANDOM = new Random();
    private static ItemStack RANDOM_STACK = ItemStack.f_41583_;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        for (VanillaWoodVariant vanillaWoodVariant : VanillaWoodVariant.values()) {
            ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), vanillaWoodVariant.m_7912_());
        }
        if (SupportMods.BIOMESOPLENTY.isLoaded()) {
            for (Enum enum_ : BOPWoodVariant.values()) {
                ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), ((BOPWoodVariant)enum_).m_7912_());
            }
        }
        if (SupportMods.TWILIGHT_FOREST.isLoaded()) {
            for (Enum enum_ : TFWoodVariant.values()) {
                ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), ((TFWoodVariant)enum_).m_7912_());
            }
        }
        if (SupportMods.TROPICRAFT.isLoaded()) {
            ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), SupportMods.TROPICRAFT.m_7912_() + "_" + TropicraftVariant.PALM.m_7912_());
            ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), SupportMods.TROPICRAFT.m_7912_() + "_" + TropicraftVariant.MAHOGANY.m_7912_());
        }
        if (SupportMods.BYG.isLoaded()) {
            if (SupportMods.EXTENSION_BYG.isLoaded()) {
                for (Enum enum_ : BYGWoodVariant.values()) {
                    ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), SupportMods.BYG.m_7912_() + "_" + ((BYGWoodVariant)enum_).m_7912_());
                }
            } else {
                WoodCutterMod.LOGGER.info("missing extension for \"Oh Biome You'll Go\" recipes");
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterBlockItems(RegistryEvent.Register<Item> event) {
        WOODCUTTERS.forEach(woodcutterBlock -> {
            Item woodcutter = (Item)new WoodcutterItem((Block)woodcutterBlock).setRegistryName(Helper.getRegistryName(woodcutterBlock));
            event.getRegistry().register((IForgeRegistryEntry)woodcutter);
            WOODCUTTER_ITEMS.add(woodcutter);
        });
        Reflection.initialize((Class[])new Class[]{ModStats.class, ModRecipeTypes.class});
    }

    private static void registerWoodcutter(IForgeRegistry<Block> registry, String name) {
        Block woodcutter = (Block)new WoodcutterBlock().setRegistryName("corail_woodcutter", name + "_woodcutter");
        registry.register((IForgeRegistryEntry)woodcutter);
        WOODCUTTERS.add(woodcutter);
    }

    public static ItemStack createRandomStack() {
        if (RANDOM_STACK.m_41619_()) {
            RANDOM_STACK = new ItemStack((ItemLike)WOODCUTTERS.stream().skip(RANDOM.nextInt(WOODCUTTERS.size())).findFirst().orElse(Blocks.f_50679_));
        }
        return RANDOM_STACK;
    }

    public static enum VanillaWoodVariant implements StringRepresentable
    {
        OAK,
        BIRCH,
        SPRUCE,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        CRIMSON,
        WARPED;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum BOPWoodVariant implements StringRepresentable
    {
        CHERRY,
        DEAD,
        FIR,
        HELLBARK,
        JACARANDA,
        MAGIC,
        MAHOGANY,
        PALM,
        REDWOOD,
        UMBRAN,
        WILLOW;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum TFWoodVariant implements StringRepresentable
    {
        TWILIGHT_OAK,
        CANOPY,
        MANGROVE,
        DARK,
        TIME,
        TRANSFORMATION,
        MINING,
        SORTING;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum TropicraftVariant implements StringRepresentable
    {
        PALM,
        MAHOGANY,
        BAMBOO,
        THATCH;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum BYGWoodVariant implements StringRepresentable
    {
        ASPEN,
        BAOBAB,
        BLUE_ENCHANTED,
        CHERRY,
        CIKA,
        CYPRESS,
        EBONY,
        FIR,
        GREEN_ENCHANTED,
        HOLLY,
        JACARANDA,
        MAHOGANY,
        MANGROVE,
        MAPLE,
        PINE,
        RAINBOW_EUCALYPTUS,
        REDWOOD,
        SKYRIS,
        WILLOW,
        WITCH_HAZEL,
        ZELKOVA,
        SYTHIAN,
        EMBUR,
        PALM,
        LAMENT,
        BULBIS,
        NIGHTSHADE,
        ETHER,
        IMPARIUS;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }
}

