/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.helper;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.woodcutter.config.ConfigWoodcutter;
import ovh.corail.woodcutter.config.CustomConfig;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModRecipeTypes;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Helper {
    public static final Comparator<Recipe<Container>> RECIPE_COMPARATOR = Comparator.comparing(recipe -> {
        String[] name = Helper.getRegistryPath(recipe.m_8043_().m_41720_()).split("_");
        return name[name.length - 1];
    }).thenComparing(recipe -> Helper.getRegistryName(recipe.m_8043_().m_41720_()));

    public static void initItemModels() {
        ModBlocks.WOODCUTTERS.forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
    }

    public static void registerSharedConfig() {
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.getActiveContainer().addConfig((ModConfig)new CustomConfig(ConfigWoodcutter.GENERAL_SPEC, ctx.getActiveContainer()));
    }

    public static List<WoodcuttingRecipe> getSortedMatchingRecipes(Level level, Container inventory) {
        return level.m_7465_().m_44054_(ModRecipeTypes.WOODCUTTING).values().stream().flatMap(recipe -> ModRecipeTypes.WOODCUTTING.m_44115_(recipe, level, inventory).stream()).sorted(RECIPE_COMPARATOR).toList();
    }

    public static ResourceLocation getRegistryRL(ItemStack stack) {
        return Helper.getRegistryRL(stack.m_41720_());
    }

    public static ResourceLocation getRegistryRL(IForgeRegistryEntry<?> entry) {
        return entry.getRegistryName();
    }

    public static String getRegistryNamespace(IForgeRegistryEntry<?> entry) {
        return Optional.ofNullable(entry.getRegistryName()).map(ResourceLocation::m_135827_).map(String::toString).orElse("");
    }

    public static String getRegistryPath(IForgeRegistryEntry<?> entry) {
        return Optional.ofNullable(entry.getRegistryName()).map(ResourceLocation::m_135815_).map(String::toString).orElse("");
    }

    public static String getRegistryName(IForgeRegistryEntry<?> entry) {
        return Optional.ofNullable(entry.getRegistryName()).map(ResourceLocation::toString).orElse("");
    }

    public static void fillItemSet(Set<Item> items, TagKey<Item> tagKey) {
        Registry.f_122827_.m_206058_(tagKey).forEach(holder -> items.add((Item)holder.m_203334_()));
    }

    public static Iterable<Holder<Item>> getItems(TagKey<Item> tagKey) {
        return Registry.f_122827_.m_206058_(tagKey);
    }

    public static boolean isInTag(Item item, TagKey<Item> tagKey) {
        return StreamSupport.stream(Registry.f_122827_.m_206058_(tagKey).spliterator(), false).anyMatch(holder -> holder.m_203334_() == item);
    }
}

