/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AltarRecipe
extends ModRecipe {
    public final Ingredient input;
    public final ItemStack output;
    public final IAuraType requiredType;
    public final Ingredient catalyst;
    public final int aura;
    public final int time;

    public AltarRecipe(ResourceLocation name, Ingredient input, ItemStack output, IAuraType requiredType, Ingredient catalyst, int aura, int time) {
        super(name);
        this.input = input;
        this.output = output;
        this.requiredType = requiredType;
        this.catalyst = catalyst;
        this.aura = aura;
        this.time = time;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.ALTAR_SERIAIZER;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.ALTAR_TYPE;
    }

    public ItemStack getDimensionBottle() {
        ItemStack bottle = ItemAuraBottle.setType(new ItemStack((ItemLike)ModItems.AURA_BOTTLE), this.requiredType);
        bottle.m_41714_((Component)new TranslatableComponent("info.naturesaura.required_aura_type." + this.requiredType.getName()));
        return bottle;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<AltarRecipe> {
        public AltarRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new AltarRecipe(recipeId, Ingredient.m_43917_((JsonElement)json.getAsJsonObject("input")), CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("output"), (boolean)true), NaturesAuraAPI.AURA_TYPES.get(new ResourceLocation(json.get("aura_type").getAsString())), json.has("catalyst") ? Ingredient.m_43917_((JsonElement)json.getAsJsonObject("catalyst")) : Ingredient.f_43901_, json.get("aura").getAsInt(), json.get("time").getAsInt());
        }

        @Nullable
        public AltarRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AltarRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_(), NaturesAuraAPI.AURA_TYPES.get(buffer.m_130281_()), Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readInt(), buffer.readInt());
        }

        public void toNetwork(FriendlyByteBuf buffer, AltarRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.m_130085_(recipe.requiredType.getName());
            recipe.catalyst.m_43923_(buffer);
            buffer.writeInt(recipe.aura);
            buffer.writeInt(recipe.time);
        }
    }
}

