/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemBreakPrevention
extends ItemImpl {
    public ItemBreakPrevention() {
        super("break_prevention");
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    public static class Events {
        @SubscribeEvent
        public void onAnvilUpdate(AnvilUpdateEvent event) {
            ItemStack stack = event.getLeft();
            if (!stack.m_41763_()) {
                return;
            }
            ItemStack second = event.getRight();
            if (second.m_41720_() != ModItems.BREAK_PREVENTION) {
                return;
            }
            ItemStack output = stack.m_41777_();
            output.m_41784_().m_128379_("naturesaura:break_prevention", true);
            event.setOutput(output);
            event.setMaterialCost(1);
            event.setCost(1);
        }

        @SubscribeEvent
        public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!stack.m_41782_() || !stack.m_41783_().m_128471_("naturesaura:break_prevention")) {
                return;
            }
            if (ElytraItem.m_41140_((ItemStack)stack)) {
                return;
            }
            event.setNewSpeed(0.0f);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (!stack.m_41782_() || !stack.m_41783_().m_128471_("naturesaura:break_prevention")) {
                return;
            }
            List tooltip = event.getToolTip();
            tooltip.add(new TranslatableComponent("info.naturesaura.break_prevention").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            if (ElytraItem.m_41140_((ItemStack)stack)) {
                return;
            }
            if (tooltip.size() < 1) {
                return;
            }
            Component head = (Component)tooltip.get(0);
            if (head instanceof MutableComponent) {
                ((MutableComponent)head).m_7220_((Component)new TranslatableComponent("info.naturesaura.broken").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            }
        }
    }
}

