/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.brigadier.CommandDispatcher;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.chunk.AuraChunkProvider;
import de.ellpeck.naturesaura.commands.CommandAura;
import de.ellpeck.naturesaura.gen.ModFeatures;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class CommonEvents {
    private static final Method GET_LOADED_CHUNKS_METHOD = ObfuscationReflectionHelper.findMethod(ChunkMap.class, (String)"m_140416_", (Class[])new Class[0]);
    private static final ListMultimap<UUID, ChunkPos> PENDING_AURA_CHUNKS = ArrayListMultimap.create();

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (((Boolean)ModConfig.instance.auraBlooms.get()).booleanValue()) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.Placed.AURA_BLOOM);
            switch (event.getCategory()) {
                case DESERT: {
                    event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.Placed.AURA_CACTUS);
                    break;
                }
                case NETHER: {
                    event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.Placed.CRIMSON_AURA_MUSHROOM);
                    event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.Placed.WARPED_AURA_MUSHROOM);
                    break;
                }
                case MUSHROOM: {
                    event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.Placed.AURA_MUSHROOM);
                }
            }
        }
    }

    @SubscribeEvent
    public void onChunkCapsAttach(AttachCapabilitiesEvent<LevelChunk> event) {
        LevelChunk chunk = (LevelChunk)event.getObject();
        event.addCapability(new ResourceLocation("naturesaura", "aura"), (ICapabilityProvider)new AuraChunkProvider(chunk));
    }

    @SubscribeEvent
    public void onLevelCapsAttach(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("naturesaura", "data"), (ICapabilityProvider)new LevelData());
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        LevelChunk chunk;
        IAuraChunk auraChunk;
        ChunkAccess iChunk = event.getChunk();
        if (iChunk instanceof LevelChunk && (auraChunk = (IAuraChunk)(chunk = (LevelChunk)iChunk).getCapability(NaturesAuraAPI.CAP_AURA_CHUNK).orElse(null)) instanceof AuraChunk) {
            LevelData data = (LevelData)ILevelData.getLevelData(chunk.m_62953_());
            data.auraChunksWithSpots.remove(chunk.m_7697_().m_45588_());
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        Player player = event.getPlayer();
        if (player.f_19853_.f_46443_) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.m_41619_() && held.m_41720_().getRegistryName().m_135815_().contains("chisel") && NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.containsKey((Object)(state = player.f_19853_.m_8055_(event.getPos())))) {
            LevelData data = (LevelData)ILevelData.getLevelData(player.f_19853_);
            data.addMossStone(event.getPos());
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.WorldTickEvent event) {
        if (!event.world.f_46443_ && event.phase == TickEvent.Phase.END && event.world.m_46467_() % 20L == 0L) {
            event.world.m_46473_().m_6180_("naturesaura:onLevelTick");
            try {
                ChunkMap manager = ((ServerChunkCache)event.world.m_7726_()).f_8325_;
                Iterable chunks = (Iterable)GET_LOADED_CHUNKS_METHOD.invoke((Object)manager, new Object[0]);
                for (ChunkHolder holder : chunks) {
                    AuraChunk auraChunk;
                    LevelChunk chunk = holder.m_140085_();
                    if (chunk == null || (auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.CAP_AURA_CHUNK, null).orElse(null)) == null) continue;
                    auraChunk.update();
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                NaturesAura.LOGGER.fatal((Object)e);
            }
            event.world.m_46473_().m_7238_();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.END) {
            if (event.player.f_19853_.m_46467_() % 10L == 0L) {
                List pending = PENDING_AURA_CHUNKS.get((Object)event.player.m_142081_());
                pending.removeIf(p -> this.handleChunkWatchDeferred(event.player, (ChunkPos)p));
            }
            if (event.player.f_19853_.m_46467_() % 200L != 0L) {
                return;
            }
            int aura = IAuraChunk.triangulateAuraInArea(event.player.f_19853_, event.player.m_142538_(), 25);
            if (aura <= 0) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "negative_imbalance"), "triggered_in_code");
            } else if (aura >= 1500000) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "positive_imbalance"), "triggered_in_code");
            }
        }
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch event) {
        PENDING_AURA_CHUNKS.put((Object)event.getPlayer().m_142081_(), (Object)event.getPos());
    }

    private boolean handleChunkWatchDeferred(Player player, ChunkPos pos) {
        ChunkAccess chunk = Helper.getLoadedChunk((LevelAccessor)player.f_19853_, pos.f_45578_, pos.f_45579_);
        if (!(chunk instanceof LevelChunk)) {
            return false;
        }
        LevelChunk levelChunk = (LevelChunk)chunk;
        AuraChunk auraChunk = (AuraChunk)levelChunk.getCapability(NaturesAuraAPI.CAP_AURA_CHUNK, null).orElse(null);
        if (auraChunk == null) {
            return false;
        }
        PacketHandler.sendTo(player, auraChunk.makePacket());
        return true;
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        CommandAura.register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
    }
}

