/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockEntityImpl
extends BlockEntity {
    public int redstonePower;
    private LazyOptional<IItemHandler> itemHandler;
    private LazyOptional<IAuraContainer> auraContainer;

    public BlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNBT(compound, SaveType.TILE);
    }

    public void m_142466_(CompoundTag compound) {
        this.readNBT(compound, SaveType.TILE);
    }

    public void writeNBT(CompoundTag compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.m_183515_(compound);
            compound.m_128405_("redstone", this.redstonePower);
        }
    }

    public void readNBT(CompoundTag compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.m_142466_(compound);
            this.redstonePower = compound.m_128451_("redstone");
        }
    }

    public void onRedstonePowerChange(int newPower) {
        this.redstonePower = newPower;
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, e -> {
            CompoundTag compound = new CompoundTag();
            this.writeNBT(compound, SaveType.SYNC);
            return compound;
        });
    }

    public final CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.writeNBT(compound, SaveType.SYNC);
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNBT(tag, SaveType.SYNC);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.readNBT(pkt.m_131708_(), SaveType.SYNC);
    }

    public void sendToClients() {
        ServerLevel world = (ServerLevel)this.m_58904_();
        List entities = world.m_7726_().f_8325_.m_183262_(new ChunkPos(this.m_58899_()), false);
        ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
        for (ServerPlayer e : entities) {
            e.f_8906_.m_141995_((Packet)packet);
        }
    }

    public IItemHandlerModifiable getItemHandler() {
        return null;
    }

    public IAuraContainer getAuraContainer() {
        return null;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandler == null) {
                IItemHandlerModifiable handler = this.getItemHandler();
                this.itemHandler = handler == null ? LazyOptional.empty() : LazyOptional.of(() -> BlockEntityImpl.lambda$getCapability$1((IItemHandler)handler));
            }
            return this.itemHandler.cast();
        }
        if (capability == NaturesAuraAPI.CAP_AURA_CONTAINER) {
            if (this.auraContainer == null) {
                IAuraContainer container = this.getAuraContainer();
                this.auraContainer = container == null ? LazyOptional.empty() : LazyOptional.of(() -> container);
            }
            return this.auraContainer.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
        if (this.auraContainer != null) {
            this.auraContainer.invalidate();
        }
    }

    public void dropInventory() {
        IItemHandlerModifiable handler = this.getItemHandler();
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
                this.f_58857_.m_7967_((Entity)item);
            }
        }
    }

    public void modifyDrop(ItemStack regularItem) {
        CompoundTag compound = new CompoundTag();
        this.writeNBT(compound, SaveType.BLOCK);
        if (!compound.m_128456_()) {
            if (!regularItem.m_41782_()) {
                regularItem.m_41751_(new CompoundTag());
            }
            regularItem.m_41783_().m_128365_("data", (Tag)compound);
        }
    }

    public void loadDataOnPlace(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41782_() && (compound = stack.m_41783_().m_128469_("data")) != null) {
            this.readNBT(compound, SaveType.BLOCK);
        }
    }

    public boolean canGenerateRightNow(int toAdd) {
        BlockState below;
        if (this.wantsLimitRemover() && (below = this.f_58857_.m_8055_(this.f_58858_.m_7495_())).m_60734_() == ModBlocks.GENERATOR_LIMIT_REMOVER) {
            return true;
        }
        int aura = IAuraChunk.getAuraInArea(this.f_58857_, this.f_58858_, 35);
        return aura + toAdd <= 2000000;
    }

    public boolean wantsLimitRemover() {
        return false;
    }

    public void generateAura(int amount) {
        while (amount > 0) {
            BlockPos spot = IAuraChunk.getLowestSpot(this.f_58857_, this.f_58858_, 35, this.f_58858_);
            amount -= IAuraChunk.getAuraChunk(this.f_58857_, spot).storeAura(spot, amount);
        }
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$1(IItemHandler handler) {
        return handler;
    }

    public static enum SaveType {
        TILE,
        SYNC,
        BLOCK;

    }
}

